/*
 * sfas.4.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <sfas-names.h>
#include <sfas-types.h>

#define back(miss)			((const char *) (miss))

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

static int back_node(const struct fpnode_type *, void *,
		     int (*) (void *, const char *, unsigned));

static int
back_node(const struct fpnode_type *fpnode_data, void *back,
	  int (*call) (void *, const char *, unsigned))
{
    int delete;

    if (extant(fpnode_data)) {
	unsigned size;

	size = spread(fpnode_data);

	fpnode_data = fpnode_data->data;

	while (1) {
	    delete = back_node(fpnode_data, back, call);
	    if (delete) {
		break;
	    } else {
		size--;
		if (size) {
		    fpnode_data++;
		} else {
		    break;
		}
	    }
	}
    } else {
	byte *base;
	unsigned copy;

	base = fpnode_data->base;

	copy = length(fpnode_data);
	if (copy < Record) {
	} else {
	    copy += strlen(back(base) + Record);
	}

	delete = call(back, back(base), copy);
    }

    return delete;
}


int
x1f4_note_sfnote(void *sfnote, void *back,
		 int (*call) (void *, const char *, unsigned))
{
    int delete;
    struct fpnode_type *fpnode_data;

    fpnode_data = sfnote(sfnote)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	delete = back_node(fpnode_data, back, call);
    } else {
	delete = 0;
    }

    return delete;
}
