/*
 * sfas.2.c
 * Copyright (C) 2009-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <sfas-defs.h>
#include <sfas-names.h>
#include <sfas-patch.h>
#include <sfas-types.h>

#define back(miss)			((const char *) (miss))
#define fast(miss)			((const byte *) (miss))

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

static int case_deck(void *, struct fpnode_type *, const byte *, unsigned, int,
		     int, const byte *, unsigned, void **);
static int ever_deck(void *, struct fpnode_type *, int, const byte *, unsigned,
		     void **);
static int line_deck(void *, struct fpnode_type **, struct fpnode_type *,
		     unsigned, unsigned, unsigned *, int, const byte *,
		     unsigned, void **);
static int mind_deck(void *, struct fpnode_type *, const byte *, const byte *,
		     unsigned, void **);
static int none_deck(void *, struct fpnode_type *, byte *, byte *);
static int post_deck(void *, struct fpnode_type **, unsigned *, const byte *,
		     const byte *, unsigned, void **);
static int post_line(void *, const byte *, unsigned, void **);
static int post_name(void *, const byte *, unsigned, void **);
static int post_pair(void *, const byte *, unsigned, void **);
static int post_slip(void *, const byte *, unsigned, void **);

static int
case_deck(void *sfnote, struct fpnode_type *fpnode_slip, const byte *slip,
	  unsigned suffix, int e, int c, const byte *name, unsigned decq,
	  void **post)
{
    int status;
    void *node;

    status = sfnote(sfnote)->link_m.link
	(sfnote(sfnote)->link_m.data, &node, sizeof(struct fpnode_type) << 2);
    if (status) {
	status = LINK_ERROR;
    } else {
	unsigned bits, length;

	bits = fpnode_slip->bits;

	length = strlen(back(name));
	if (0) {
	} else {
	    void *sand;

	    status = sfnote(sfnote)->link_m.link
		(sfnote(sfnote)->link_m.data, &sand, decq + length + 1);
	    if (status) {
		status = LINK_ERROR;

		sfnote(sfnote)->link_m.free(sfnote(sfnote)->link_m.data, node);
	    } else {
		if (extant(fpnode_slip)) {
		    if (suffix < sizeof(byte *) + 2) {
			struct fpnode_type *fpnode_data;
			void *last;

			fpnode_data = node;

			*post = sand;

			last = (char *) sand + decq;

			memcpy(last, name, length + 1);

			if (c < e + 1) {
			    fpnode_data->base = last;
			    fpnode_data->bits = dset(c, length);
			    fpnode_data->data = sand;

			    fpnode_data++;

			    suffix--;

			    fpnode_data->bits = pset(e, suffix, bits);
			    fpnode_data->data = fpnode_slip->data;

			    if (suffix) {
				memcpy(&fpnode_data->base, slip + 1, suffix);
			    }
			} else {
			    suffix--;

			    fpnode_data->bits = pset(e, suffix, bits);
			    fpnode_data->data = fpnode_slip->data;

			    if (suffix) {
				memcpy(&fpnode_data->base, slip + 1, suffix);
			    }

			    fpnode_data++;

			    fpnode_data->base = last;
			    fpnode_data->bits = dset(c, length);
			    fpnode_data->data = sand;
			}

			fpnode_slip->data = node;
		    } else {
			void *flat;

			status = sfnote(sfnote)->link_m.link
			    (sfnote(sfnote)->link_m.data, &flat, suffix);
			if (status) {
			    status = LINK_ERROR;

			    sfnote(sfnote)->link_m.free
				(sfnote(sfnote)->link_m.data, sand);
			    sfnote(sfnote)->link_m.free
				(sfnote(sfnote)->link_m.data, node);
			} else {
			    struct fpnode_type *fpnode_data;
			    void *last;

			    fpnode_data = node;

			    *post = sand;

			    last = (char *) sand + decq;

			    memcpy(last, name, length + 1);

			    memcpy(flat, slip + 1, suffix);

			    suffix--;

			    if (c < e + 1) {
				fpnode_data->base = last;
				fpnode_data->bits = dset(c, length);
				fpnode_data->data = sand;

				fpnode_data++;

				fpnode_data->base = flat;
				fpnode_data->bits = pset(e, suffix, bits);
				fpnode_data->data = fpnode_slip->data;
			    } else {
				fpnode_data->base = flat;
				fpnode_data->bits = pset(e, suffix, bits);
				fpnode_data->data = fpnode_slip->data;

				fpnode_data++;

				fpnode_data->base = last;
				fpnode_data->bits = dset(c, length);
				fpnode_data->data = sand;
			    }

			    fpnode_slip->data = node;
			}
		    }
		} else {
		    struct fpnode_type *fpnode_data;
		    void *last;

		    fpnode_data = node;

		    *post = sand;

		    last = (char *) sand + decq;

		    memcpy(last, name, length + 1);

		    if (c < e + 1) {
			fpnode_data->base = last;
			fpnode_data->bits = dset(c, length);
			fpnode_data->data = sand;

			fpnode_data++;

			fpnode_data->base = fpnode_slip->base;
			fpnode_data->bits = zset(bits, e);
			fpnode_data->data = fpnode_slip->data;
		    } else {
			fpnode_data->base = fpnode_slip->base;
			fpnode_data->bits = zset(bits, e);
			fpnode_data->data = fpnode_slip->data;

			fpnode_data++;

			fpnode_data->base = last;
			fpnode_data->bits = dset(c, length);
			fpnode_data->data = sand;
		    }

		    fpnode_slip->data = node;
		}
	    }
	}
    }

    return status;
}


static int
ever_deck(void *sfnote, struct fpnode_type *fpnode_slip, int c,
	  const byte *name, unsigned decq, void **post)
{
    int status;
    void *node;

    status = sfnote(sfnote)->link_m.link
	(sfnote(sfnote)->link_m.data, &node, sizeof(struct fpnode_type) << 2);
    if (status) {
	status = LINK_ERROR;
    } else {
	unsigned length;

	length = strlen(back(name));
	if (0) {
	} else {
	    unsigned bits;
	    void *sand;

	    status = sfnote(sfnote)->link_m.link
		(sfnote(sfnote)->link_m.data, &sand, decq + length + 1);
	    if (status) {
		status = LINK_ERROR;

		sfnote(sfnote)->link_m.free(sfnote(sfnote)->link_m.data, node);
	    } else {
		struct fpnode_type *fpnode_data;

		fpnode_data = node;

		*post = sand;

		bits = fpnode_slip->bits;

		fpnode_data->data = fpnode_slip->data;
		fpnode_data->base = fpnode_slip->base;
		fpnode_data->bits = zset(bits, 0);

		fpnode_data++;

		fpnode_data->data = sand;

		sand = (char *) sand + decq;

		memcpy(sand, name, length + 1);

		fpnode_data->base = sand;
		fpnode_data->bits = dset(c, length);

		fpnode_slip->data = node;
	    }
	}
    }

    return status;
}


static int
line_deck(void *sfnote, struct fpnode_type **fpnode,
	  struct fpnode_type *fpnode_data, unsigned line, unsigned fast,
	  unsigned *size, int c, const byte *name, unsigned decq, void **post)
{
    int status;

    do {
	unsigned length;

	if (fast & 3) {
	} else {
	    void *node;

	    node = fpnode_data;

	    status = sfnote(sfnote)->link_m.mode
		(sfnote(sfnote)->link_m.data, &node,
		 (fast + 4) * sizeof(struct fpnode_type));
	    if (status) {
		status = MODE_ERROR;
		if (1) {
		    break;
		}
	    } else {
		*fpnode = node;

		fpnode_data = node;
	    }
	}

	length = strlen(back(name));
	if (0) {
	} else {
	    void *sand;

	    status = sfnote(sfnote)->link_m.link
		(sfnote(sfnote)->link_m.data, &sand, decq + length + 1);
	    if (status) {
		status = LINK_ERROR;
	    } else {
		fpnode_data += line;

		memmove(fpnode_data + 1, fpnode_data,
			(fast - line) * sizeof(struct fpnode_type));

		*post = sand;

		fpnode_data->data = sand;

		sand = (char *) sand + decq;

		memcpy(sand, name, length + 1);

		fpnode_data->base = sand;
		fpnode_data->bits = dset(c, length);

		*size = fast + 1;
	    }
	}
    } while (0);

    return status;
}


static int
mind_deck(void *sfnote, struct fpnode_type *fpnode_data, const byte *lead,
	  const byte *name, unsigned decq, void **post)
{
    int status;
    struct fpnode_type *fpnode_slip;
    unsigned bits, size;

    bits = fpnode_data->bits;
    fpnode_slip = (struct fpnode_type *) fpnode_data->data;

    size = Spread(bits);

    status = post_deck(sfnote, &fpnode_slip, &size, lead, name, decq, post);
    if (status) {
    } else {
	fpnode_data->bits = iset(bits, size);
	fpnode_data->data = fpnode_slip;
    }

    return status;
}


static int
none_deck(void *sfnote, struct fpnode_type *fpnode_slip, byte *call,
	  byte *slip)
{
    int status;
    unsigned bits, length, prefix;

    bits = fpnode_slip->bits;

    if (Extant(bits)) {
	length = Length(bits);
	if (sizeof(byte *) < length) {
	    void *miss;

	    miss = fpnode_slip->base;

	    prefix = slip - fast(miss);

	    if (sizeof(byte *) < prefix) {
		*slip = 0;

		status = sfnote(sfnote)->link_m.mode
		    (sfnote(sfnote)->link_m.data, &miss, prefix + 1);
		if (status) {
		    status = MODE_ERROR;
		} else {
		    byte *text;

		    text = miss;

		    text[prefix] = 0;

		    fpnode_slip->base = miss;
		}
	    } else {
		memcpy(&fpnode_slip->base, miss, prefix);

		status = sfnote(sfnote)->link_m.free
		    (sfnote(sfnote)->link_m.data, miss);
		if (status) {
		    status = FREE_ERROR;
		    if (1) {
			fpnode_slip->base = miss;
		    }
		}
	    }
	} else {
	    prefix = slip - (byte *) &fpnode_slip->base;

	    status = 0;
	}
    } else {
	void *miss;

	prefix = slip - call;

	miss = fpnode_slip->base;

	if (sizeof(byte *) < prefix) {
	    status = sfnote(sfnote)->link_m.link
		(sfnote(sfnote)->link_m.data, &miss, prefix + 1);
	    if (status) {
		status = LINK_ERROR;

		prefix = 0;
	    } else {
		byte *text;

		text = miss;

		text[prefix] = 0;

		fpnode_slip->base = miss;

		memcpy(miss, call, prefix);
	    }
	} else {
	    status = 0;

	    memcpy(&fpnode_slip->base, call, prefix);
	}
    }

    fpnode_slip->bits = nset(prefix, bits, 2);

    return status;
}


static int
post_deck(void *sfnote, struct fpnode_type **fpnode, unsigned *size,
	  const byte *lead, const byte *name, unsigned decq, void **post)
{
    int c, status;
    struct fpnode_type *fpnode_slip;

    fpnode_slip = *fpnode;

    c = *name;
    if (c) {
	struct fpnode_type *fpnode_data;
	unsigned bits, mind;

	mind = *size;

	fpnode_data = fpnode_slip;

	Progress_node(fpnode_data, mind - 1);

	bits = fpnode_data->bits;

	if (Prefix(bits) == c) {
	    byte *call, *slip;
	    int e;
	    unsigned length;

	    length = Length(bits);

	    name++;

	    if (Extant(bits)) {
		if (sizeof(byte *) < length) {
		    slip = fpnode_data->base;
		    if (length < Record) {
		    } else {
			length += strlen(back(slip) + Record);
		    }
		} else {
		    slip = (byte *) &fpnode_data->base;
		}
	    } else {
		unsigned offset;

		slip = fpnode_data->base;

		if (length < Record) {
		} else {
		    length += strlen(back(slip) + Record);
		}

		offset = name - lead;
		slip += offset;
		length -= offset;
	    }

	    call = slip;

	    if (1) {
		while (1) {
		    if (length) {
			c = *name;
			e = *slip;
			if (c == e) {
			    if (c) {
				slip++;
				name++;
				length--;
			    } else {
				break;
			    }
			} else {
			    break;
			}
		    } else {
			c = *name;
			e = 0;
			if (1) {
			    break;
			}
		    }
		}
	    }
	    if (e) {
		status = case_deck
		    (sfnote, fpnode_data, slip, length, e, c, lead, decq,
		     post);
		if (status) {
		} else {
		    status = none_deck(sfnote, fpnode_data, call, slip);
		}
	    } else {
		if (Extant(bits)) {
		    status = mind_deck
			(sfnote, fpnode_data, lead, name, decq, post);
		} else {
		    if (c) {
			status = ever_deck
			    (sfnote, fpnode_data, c, lead, decq, post);
			if (status) {
			} else {
			    status = none_deck
				(sfnote, fpnode_data, call, slip);
			}
		    } else {
			status = EVER_MATCH;

			*post = fpnode_data->data;
		    }
		}
	    }
	} else {
	    unsigned line;

	    line = fpnode_data - fpnode_slip;

	    if (c < Prefix(bits)) {
	    } else {
		line++;
	    }

	    status = line_deck
		(sfnote, fpnode, fpnode_slip, line, mind, size, *name, lead,
		 decq, post);
	}
    } else {
	if (prefix(fpnode_slip)) {
	    status = line_deck
		(sfnote, fpnode, fpnode_slip, 0, *size, size, *name, lead,
		 decq, post);
	} else {
	    status = EVER_MATCH;

	    *post = fpnode_slip->data;
	}
    }

    return status;
}


static int
post_line(void *sfnote, const byte *name, unsigned decq, void **post)
{
    int status;
    void *node;

    status = sfnote(sfnote)->link_m.link
	(sfnote(sfnote)->link_m.data, &node, sizeof(struct fpnode_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	unsigned length;

	length = strlen(back(name));
	if (0) {
	} else {
	    void *sand;

	    status = sfnote(sfnote)->link_m.link
		(sfnote(sfnote)->link_m.data, &sand, decq + length + 1);
	    if (status) {
		status = LINK_ERROR;

		sfnote(sfnote)->link_m.free(sfnote(sfnote)->link_m.data, node);
	    } else {
		struct fpnode_type *fpnode_data;

		sfnote(sfnote)->link_a.fpdeck.fpnode_data = node;

		*post = sand;

		fpnode_data = node;

		fpnode_data->data = sand;

		sand = (char *) sand + decq;

		memcpy(sand, name, length + 1);

		fpnode_data->base = sand;
		fpnode_data->bits = dset(*name, length);
	    }
	}
    }

    return status;
}


static int
post_name(void *sfnote, const byte *name, unsigned decq, void **post)
{
    int status;
    struct fpnode_type *fpnode_data, *fpnode_slip;
    unsigned size;

    fpnode_data = sfnote(sfnote)->link_a.fpdeck.fpnode_data;

    size = spread(fpnode_data);
    fpnode_slip = (struct fpnode_type *) fpnode_data->data;

    status = post_deck(sfnote, &fpnode_slip, &size, name, name, decq, post);
    if (status) {
    } else {
	fpnode_data->bits = eset(size);
	fpnode_data->data = fpnode_slip;
    }

    return status;
}


static int
post_pair(void *sfnote, const byte *name, unsigned decq, void **post)
{
    int status;
    void *node;

    status = sfnote(sfnote)->link_m.link
	(sfnote(sfnote)->link_m.data, &node, sizeof(struct fpnode_type) << 2);
    if (status) {
	status = LINK_ERROR;
    } else {
	struct fpnode_type *fpnode_data, *fpnode_slip;
	unsigned size = 1;

	fpnode_data = sfnote(sfnote)->link_a.fpdeck.fpnode_data;

	fpnode_slip = node;

	*fpnode_slip = *fpnode_data;

	fpnode_data->bits = eset(1);
	fpnode_data->data = fpnode_slip;

	status = post_deck
	    (sfnote, &fpnode_slip, &size, name, name, decq, post);
	if (status) {
	} else {
	    fpnode_data->bits = eset(size);
	    fpnode_data->data = fpnode_slip;
	}
    }

    return status;
}


static int
post_slip(void *sfnote, const byte *name, unsigned decq, void **post)
{
    int status;
    struct fpnode_type *fpnode_data;
    unsigned size = 1;

    fpnode_data = sfnote(sfnote)->link_a.fpdeck.fpnode_data;

    status = post_deck(sfnote, &fpnode_data, &size, name, name, decq, post);
    if (status) {
    } else {
	if (0) {
	    sfnote(sfnote)->link_a.fpdeck.fpnode_data = fpnode_data;
	}
    }

    return status;
}


int
x1f4_post_sfnote(void *sfnote, const char *name, unsigned decq, void **post)
{
    int status;
    struct fpnode_type *fpnode_data;

    fpnode_data = sfnote(sfnote)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	int prefix;

	prefix = prefix(fpnode_data);
	if (prefix) {
	    if (prefix == *name) {
		status = post_slip(sfnote, fast(name), decq, post);
	    } else {
		status = post_pair(sfnote, fast(name), decq, post);
	    }
	} else {
	    if (extant(fpnode_data)) {
		status = post_name(sfnote, fast(name), decq, post);
	    } else {
		if (*name) {
		    status = post_pair(sfnote, fast(name), decq, post);
		} else {
		    status = post_slip(sfnote, fast(name), decq, post);
		}
	    }
	}
    } else {
	status = post_line(sfnote, fast(name), decq, post);
    }

    return status;
}
