/*
 * sfas.1.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>

#include <mask.0.h>
#include <sfas-defs.h>
#include <sfas-names.h>
#include <sfas-types.h>
#include <trans.h>

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

int
x1f4_fast_sfnote(void *sfnote, unsigned flags,
		 struct screen_type *screen_data)
{
    if (0) {
    } else {
	sfnote(sfnote)->link_a.fpdeck.fpnode_data = NULL;

	if (flags & TRANS_MASK) {
	    struct trans_type *trans_data;

	    trans_data = screen_data->trans_data;

	    sfnote(sfnote)->link_m.data = trans_data->data;
	    sfnote(sfnote)->link_m.free = trans_data->free;
	    sfnote(sfnote)->link_m.link = trans_data->link;
	    sfnote(sfnote)->link_m.mode = trans_data->mode;
	} else {
	    sfnote(sfnote)->link_m.free = _libx1f4l2_free_data;
	    sfnote(sfnote)->link_m.link = _libx1f4l2_link_data;
	    sfnote(sfnote)->link_m.mode = _libx1f4l2_mode_data;
	}
    }

    return 0;
}
