/*
 * sfas-types.h
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_sfas_types_H__
#define __LIBx1f4_sfas_types_H__

#include <config.h>

#include <stddef.h>

#include <trans.h>

#define Record				32767

#define Extant(mode) \
    ((mode) & 65536)
#define Length(mode) \
    ((mode) >> 17)
#define Prefix(mode) \
    ((mode) & 255)
#define Spread(mode) \
    (((mode) >> 8 & 255) + 1)

#define Effect(mode) \
    ((mode) >> 8 & 255)

#define extant(node) \
    Extant(((struct fpnode_type *) (node))->bits)
#define length(node) \
    (((struct fpnode_type *) (node))->bits >> 17)
#define prefix(node) \
    (((struct fpnode_type *) (node))->bits & 255)
#define spread(node) \
    Spread(((struct fpnode_type *) (node))->bits)

#define effect(node) \
    Effect(((struct fpnode_type *) (node))->bits)

#if WORDS_BIGENDIAN
# define prefixof() \
    (offsetof(struct fpnode_type, bits) + sizeof(unsigned) - 1)
#else
# define prefixof() \
    offsetof(struct fpnode_type, bits)
#endif				/* WORDS_BIGENDIAN */

#define dset(prefix, length) \
    ((prefix) | sfff(length) << 17)

#define eset(spread) \
    (((spread) - 1) << 8 | 65536)

#define iset(bits, spread) \
    (((spread) - 1) << 8 | ((bits) & ~65280))

#define jset(bits, spread) \
    (((spread) - 1) << 8 | (bits) | 65536)

#define nset(length, bits, spread) \
    (sfff(length) << 17 | ((spread) - 1) << 8 | ((bits) & 255) | 65536)

#define pset(prefix, length, bits) \
    (dset(prefix, length) | ((bits) & 130816))

#define sfff(length) \
    ((length) < Record ? (length) : Record)

#define vset(length, bits) \
    (((bits) & ~131071) | sfff(length) << 17)

#define zset(bits, prefix) \
    (((bits) & ~255) | (prefix))

typedef unsigned char byte;

typedef struct fpnode_type {
    byte *base;
    unsigned bits;
    void *data;
} fpnode_type;

typedef struct fpdeck_type {
    struct fpnode_type *fpnode_data;
} fpdeck_type;

typedef struct screen_type {
    struct trans_type *trans_data;
} screen_type;

typedef struct sfnote_type {
    struct {
	struct fpdeck_type fpdeck;
    } link_a;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
} sfnote_type;

#endif				/* __LIBx1f4_sfas_types_H__ */
