/*
 * sfap.5.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <sfas-defs.h>
#include <sfas-names.h>
#include <sfas-types.h>

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

int
x1f4_lead_sfnote(void *sfnote, void **data)
{
    int status;
    const struct fpnode_type *fpnode_data;

    fpnode_data = sfnote(sfnote)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	status = 0;

	while (1) {
	    if (extant(fpnode_data)) {
		fpnode_data = fpnode_data->data;
	    } else {
		*data = fpnode_data->data;
		if (1) {
		    break;
		}
	    }
	}
    } else {
	status = DECK_ERROR;
    }

    return status;
}
