/*
 * s5xx.3.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>

#include <mask.0.h>
#include <trans.h>
#include <s5xx-defs.h>
#include <s5xx-names.h>
#include <s5xx-types.h>

#define s5deck(s5deck)			((struct s5deck_type *) (s5deck))

int
x1f4_fast_s5deck(void *s5deck, unsigned flags,
		 struct screen_type *screen_data)
{
    if (0) {
    } else {
	s5deck(s5deck)->link_a.fpdeck.fpnode_data = NULL;

	if (flags & TRANS_MASK) {
	    struct trans_type *trans_data;

	    trans_data = screen_data->trans_data;

	    s5deck(s5deck)->link_m.data = trans_data->data;
	    s5deck(s5deck)->link_m.free = trans_data->free;
	    s5deck(s5deck)->link_m.link = trans_data->link;
	    s5deck(s5deck)->link_m.mode = trans_data->mode;
	} else {
	    s5deck(s5deck)->link_m.free = _libx1f4l2_free_data;
	    s5deck(s5deck)->link_m.link = _libx1f4l2_link_data;
	    s5deck(s5deck)->link_m.mode = _libx1f4l2_mode_data;
	}
    }

    return 0;
}
