/*
 * s5xx.2.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <s5xx-names.h>
#include <s5xx-types.h>

#define s5deck(s5deck)			((struct s5deck_type *) (s5deck))

#define fpnode_data(fpnode) \
    ((struct fpnode_type **) ((struct fpnode_type *) (fpnode) + 1))

static int free_node(struct fpnode_type *, void *, int (*) (void *, void *));

static int
free_node(struct fpnode_type *fpnode_data, void *data,
	  int (*free) (void *, void *))
{
    int status;
    unsigned call;

    call = fpnode_data->data.call;
    if (call & 255) {
	int excess;

	status = free_node(fpnode_data(fpnode_data)[0], data, free);
	excess = free_node(fpnode_data(fpnode_data)[1], data, free);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}

	excess = free(data, fpnode_data);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    } else {
	status = free(data, fpnode_data);
    }

    return status;
}


int
x1f4_flat_s5deck(void *s5deck)
{
    int status;
    struct fpnode_type *fpnode_data;

    fpnode_data = s5deck(s5deck)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	status = free_node
	    (fpnode_data, s5deck(s5deck)->link_m.data,
	     s5deck(s5deck)->link_m.free);
    } else {
	status = 0;
    }

    return status;
}
