/*
 * s5xx-types.h
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_s5xx_types_H__
#define __LIBx1f4_s5xx_types_H__

#include <config.h>

#include <stddef.h>

#include <trans.h>

typedef union fpnode_class {
    unsigned call;
    void *data;
} fpnode_rate;

typedef unsigned char byte;

typedef struct fpnode_type {
    union fpnode_class data;
} fpnode_type;

typedef struct fpdeck_type {
    struct fpnode_type *fpnode_data;
} fpdeck_type;

typedef struct screen_type {
    struct trans_type *trans_data;
} screen_type;

typedef struct s5deck_type {
    struct {
	struct fpdeck_type fpdeck;
    } link_a;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
} s5deck_type;

#endif				/* __LIBx1f4_s5xx_types_H__ */
