/*
 * s5xv.9.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <s5xx-names.h>
#include <s5xx-types.h>

#define s5deck(s5deck)			((struct s5deck_type *) (s5deck))

#define fpnode_data(fpnode) \
    ((struct fpnode_type **) ((struct fpnode_type *) (fpnode) + 1))

int
x1f4_pick_s5path(void *s5deck, const char *name, unsigned size,
		 const void ***data)
{
    int delete;
    struct fpnode_type *fpnode_data;

    fpnode_data = s5deck(s5deck)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	unsigned call, rate;

	size <<= 8;

	call = fpnode_data->data.call;
	rate = call & 255;
	while (rate) {
	    if (call < size) {
		fpnode_data = fpnode_data(fpnode_data)
		    [(1 + (rate | name[call >> 8])) >> 8];
	    } else {
		do {
		    fpnode_data = fpnode_data(fpnode_data)[0];

		    call = fpnode_data->data.call;
		    if (1) {
			rate = call & 255;
		    }
		} while (rate);

		break;
	    }

	    call = fpnode_data->data.call;
	    if (1) {
		rate = call & 255;
	    }
	}

	if (call ^ size) {
	    delete = 0;
	} else {
	    delete =
		!memcmp(*(const char **) ((void **) (fpnode_data + 1) + 1),
			name, size >> 8);
	    if (delete) {
		*data = (const void **) (fpnode_data + 1);
	    }
	}
    } else {
	delete = 0;
    }

    return delete;
}
