/*
 * s5xx.n.c
 * Copyright (C) 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <s5xx-defs.h>
#include <s5xx-inter.h>
#include <s5xx-names.h>
#include <s5xx-types.h>

#define s5deck(s5deck)			((struct s5deck_type *) (s5deck))

int
x1f4_fill_s5deck(void *s5data, void *s5text)
{
    int status;

    if (s5deck(s5data)->link_a.fpdeck.fpnode_data) {
	status = SIZE_ERROR;
    } else {
	status = _libx1f4l2_pink_s5deck(s5data, s5text);
    }

    return status;
}
