/*
 * s5xv.7.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <s5xx-defs.h>
#include <s5xx-names.h>
#include <s5xx-types.h>

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#if SIZEOF_LONG == 8
# define scale(___c) \
    (___c) >>= 3
#elif SIZEOF_LONG == 4
# define scale(___c) \
    (___c) >>= 2
#else
# define scale(___c) \
    (___c) /= SIZEOF_LONG
#endif				/* SIZEOF_LONG == 8 */

#define fast(miss)			((const byte *) (miss))

#define s5deck(s5deck)			((struct s5deck_type *) (s5deck))

#define fpnode_data(fpnode) \
    ((struct fpnode_type **) ((struct fpnode_type *) (fpnode) + 1))

static int post_line(void *, const byte *, unsigned, const void *);
static int post_name(void *, const byte *, unsigned, const void *,
		     struct fpnode_type *);

static int
post_line(void *s5deck, const byte *name, unsigned size, const void *data)
{
    int status;
    void *node;

    status = s5deck(s5deck)->link_m.link
	(s5deck(s5deck)->link_m.data, &node,
	 sizeof(struct fpnode_type) + sizeof(void *) + sizeof(byte *));
    if (status) {
	status = LINK_ERROR;
    } else {
	const byte **text;
	struct fpnode_type *fpnode_data;
	const void **lock;

	s5deck(s5deck)->link_a.fpdeck.fpnode_data = node;

	fpnode_data = node;

	lock = (void *) (fpnode_data + 1);

	*lock = data;

	text = (void *) (lock + 1);

	*text = name;

	fpnode_data->data.call = size << 8;
    }

    return status;
}


static int
post_name(void *s5deck, const byte *name, unsigned size, const void *data,
	  struct fpnode_type *fpnode_data)
{
    const byte *copy;
    int status;
    unsigned call, club, rate, slip;

    size <<= 8;

    call = fpnode_data->data.call;
    rate = call & 255;
    while (rate) {
	if (call < size) {
	    fpnode_data = fpnode_data(fpnode_data)
		[(1 + (rate | name[call >> 8])) >> 8];
	} else {
	    fpnode_data = fpnode_data(fpnode_data)[0];
	}

	call = fpnode_data->data.call;
	if (1) {
	    rate = call & 255;
	}
    }

    size >>= 8;

    slip = call >> 8;

    copy = *(const byte **) ((void **) (fpnode_data + 1) + 1);

    club = size < slip ? size : slip;
    if (SIZEOF_LONG & (SIZEOF_LONG - 1)) {
    } else {
	if (((integral_q) copy | (integral_q) name) & (SIZEOF_LONG - 1)) {
	} else {
#if 0
	    call >>= 8;
	    if (club < call) {
		call = club;
	    }
#endif				/* 0 */
	    scale(call);
	    if (call) {
		const byte *fast;

		fast = copy;

		for (; call; call--) {
		    if (*(const long *) copy ^ *(const long *) name) {
			break;
		    }

		    copy = (const void *) ((const long *) copy + 1);
		    name = (const void *) ((const long *) name + 1);
		}

		club -= copy - fast;
	    }
	}
    }
    for (; club; club--) {
	rate = *copy ^ *name;
	if (rate) {
	    if (1) {
		break;
	    }
	}

	copy++;
	name++;
    }

    do {
	unsigned tier;
	void *sect;

	if (club) {
	    if (size < slip) {
		club = size - club;
	    } else {
		club = slip - club;
	    }

#if 1
	    while (rate & (rate - 1)) {
		rate &= rate - 1;
	    }
#else
	    rate |= rate >> 1;
	    rate |= rate >> 2;
	    rate |= rate >> 4;
	    rate -= rate >> 1;
#endif				/* 0 */

	    rate ^= 255;

	    slip = club << 8 | rate;

	    tier = (1 + (rate | *copy)) >> 8;
	} else {
	    if (size ^ slip) {
		rate = 0377;
		if (size < slip) {
		    club = size;
		    tier = 1;
		} else {
		    club = slip;
		    tier = 0;
		}

		slip = club << 8;
	    } else {
		status = EVER_MATCH;
		if (1) {
		    break;
		}
	    }
	}

	status = s5deck(s5deck)->link_m.link
	    (s5deck(s5deck)->link_m.data, &sect,
	     sizeof(struct fpnode_type) + (sizeof(void *) << 1));
	if (status) {
	    status = LINK_ERROR;
	} else {
	    void *node;

	    status = s5deck(s5deck)->link_m.link
		(s5deck(s5deck)->link_m.data, &node,
		 sizeof(struct fpnode_type) + sizeof(void *) + sizeof(byte *));
	    if (status) {
		status = LINK_ERROR;

		s5deck(s5deck)->link_m.free(s5deck(s5deck)->link_m.data, sect);
	    } else {
		const byte **text;
		struct fpnode_type **fpnode, *fpnode_text;
		const void **lock;

		fpnode_data = node;

		name -= club;

		lock = (void *) (fpnode_data + 1);

		*lock = data;

		text = (void *) (lock + 1);

		*text = name;

		size <<= 8;

		fpnode_data->data.call = size;

		fpnode_data = sect;

		fpnode_data->data.call = slip | rate;

		fpnode_data(fpnode_data)[1 - tier] = node;

		fpnode = &s5deck(s5deck)->link_a.fpdeck.fpnode_data;
		for (;;) {
		    fpnode_text = *fpnode;

		    call = fpnode_text->data.call;

		    rate = call & 255;

		    if (rate) {
			if (slip < call) {
			    if (call ^ (slip & ~255) ^ 255) {
				break;
			    } else {
				fpnode = fpnode_data(fpnode_text) + 1;
			    }
			} else {
			    if (call < size) {
				fpnode = fpnode_data(fpnode_text)
				    + ((1 + (rate | name[call >> 8])) >> 8);
			    } else {
				fpnode = fpnode_data(fpnode_text);
			    }
			}
		    } else {
			break;
		    }
		}

		*fpnode = fpnode_data;
		fpnode_data(fpnode_data)[tier] = fpnode_text;
	    }
	}
    } while (0);

    return status;
}


int
x1f4_post_s5path(void *s5deck, const char *name, unsigned size,
		 const void *data)
{
    int status;
    struct fpnode_type *fpnode_data;

    fpnode_data = s5deck(s5deck)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	status = post_name(s5deck, fast(name), size, data, fpnode_data);
    } else {
	status = post_line(s5deck, fast(name), size, data);
    }

    return status;
}
