/*
 * s5xv.4.c
 * Copyright (C) 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <s5xx-defs.h>
#include <s5xx-inter.h>
#include <s5xx-names.h>
#include <s5xx-types.h>
#include <trans.h>

#define s5deck(s5deck)			((struct s5deck_type *) (s5deck))

#define fpnode_data(fpnode) \
    ((struct fpnode_type **) ((struct fpnode_type *) (fpnode) + 1))

static int fast_deck(struct s5deck_type *, struct s5deck_type *);

static int
fast_deck(struct s5deck_type *s5deck_data, struct s5deck_type *s5deck_fast)
{
    struct screen_type screen;
    struct trans_type trans;

    trans.data = s5deck_fast->link_m.data;
    trans.free = s5deck_fast->link_m.free;
    trans.link = s5deck_fast->link_m.link;
    trans.mode = s5deck_fast->link_m.mode;

    screen.trans_data = &trans;

    return _libx1f4l2_fast_s5deck(s5deck_data, TRANS_MASK, &screen);
}


int
x1f4_copy_s5deck(void **z3deck, void *s5deck)
{
    int status;
    void *data;

    status = s5deck(s5deck)->link_m.link
	(s5deck(s5deck)->link_m.data, &data, sizeof(struct s5deck_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	fast_deck(data, s5deck);

	status = _libx1f4l2_pink_s5deck(data, s5deck);
	if (status) {
	    s5deck(s5deck)->link_m.free(s5deck(s5deck)->link_m.data, data);
	} else {
	    *z3deck = data;
	}
    }

    return status;
}
