/*
 * s5xi.b.c
 * Copyright (C) 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <s5xx-defs.h>
#include <s5xx-inter.h>
#include <s5xx-names.h>
#include <s5xx-types.h>

#define back(miss)			((const char *) (miss))

#define s5deck(s5deck)			((struct s5deck_type *) (s5deck))

#define fpnode_data(fpnode) \
    ((struct fpnode_type **) ((struct fpnode_type *) (fpnode) + 1))

static int back_copy(struct fpnode_type *, void *, int (*) (void *, void *));
static int copy_back(struct s5deck_type *, struct fpnode_type **,
		     struct fpnode_type *);

static int
back_copy(struct fpnode_type *fpnode_data, void *data,
	  int (*free) (void *, void *))
{
    int status;
    unsigned call;

    call = fpnode_data->data.call;
    if (call & 255) {
	int excess;

	status = back_copy(fpnode_data(fpnode_data)[0], data, free);
	excess = back_copy(fpnode_data(fpnode_data)[1], data, free);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}

	excess = free(data, fpnode_data);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    } else {
	status = free(data, fpnode_data);
    }

    return status;
}


static int
copy_back(struct s5deck_type *s5deck_data, struct fpnode_type **fpnode,
	  struct fpnode_type *fpnode_fast)
{
    int status;
    unsigned note;

    note = fpnode_fast->data.call;
    if (note & 255) {
	void *node;

	status = s5deck_data->link_m.link
	    (s5deck_data->link_m.data, &node,
	     sizeof(struct fpnode_type) + (sizeof(void *) << 1));
	if (status) {
	    status = LINK_ERROR;
	} else {
	    struct fpnode_type *fpnode_data;

	    fpnode_data = node;

	    *fpnode_data = *fpnode_fast;

	    status = copy_back
		(s5deck_data, fpnode_data(fpnode_data) + 0,
		 fpnode_data(fpnode_fast)[0]);
	    if (status) {
		s5deck_data->link_m.free(s5deck_data->link_m.data, node);
	    } else {
		status = copy_back
		    (s5deck_data, fpnode_data(fpnode_data) + 1,
		     fpnode_data(fpnode_fast)[1]);
		if (status) {
		    int (*free) (void *, void *);
		    void *data;

		    data = s5deck_data->link_m.data;
		    free = s5deck_data->link_m.free;

		    back_copy(fpnode_data(fpnode_data)[0], data, free);

		    free(data, node);
		} else {
		    *fpnode = fpnode_data;
		}
	    }
	}
    } else {
	void *node;

	status = s5deck_data->link_m.link
	    (s5deck_data->link_m.data, &node,
	     sizeof(struct fpnode_type) + sizeof(void *) + sizeof(byte *));
	if (status) {
	    status = LINK_ERROR;
	} else {
	    const byte **text;
	    struct fpnode_type *fpnode_data;
	    const void **lock;

	    fpnode_data = node;

	    lock = (void *) (fpnode_data + 1);

	    *lock = *(const void **) (fpnode_fast + 1);

	    text = (void *) (lock + 1);

	    *text = *(const byte **) ((void **) (fpnode_fast + 1) + 1);

	    fpnode_data->data.call = fpnode_fast->data.call;

	    *fpnode = fpnode_data;
	}
    }

    return status;
}


int
_libx1f4l2_pink_s5deck(void *s5data, void *s5text)
{
    int status;
    struct fpnode_type *fpnode_data;

    fpnode_data = s5deck(s5text)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	status = copy_back
	    (s5data, &s5deck(s5data)->link_a.fpdeck.fpnode_data, fpnode_data);
    } else {
	status = 0;
    }

    return status;
}
