/*
 * reverse.h
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_reverse_H__
#define __LIBx1f4_reverse_H__

#include <config.h>

#if !defined BITS_LONG
# define BITS_LONG			unsigned long
#endif				/* !BITS_LONG */

#if !defined BITS_MODE
# define BITS_MODE			unsigned
#endif				/* !BITS_MODE */

#define l2_1_reverse_1up(l4f1_c) \
    {									      \
	l4f1_c = l4f1_c >> 020 | l4f1_c << 020;				      \
	l4f1_c = (l4f1_c & 0xff00ff00) >> 010 | (l4f1_c & 0x00ff00ff) << 010; \
	l4f1_c = (l4f1_c & 0xf0f0f0f0) >> 004 | (l4f1_c & 0x0f0f0f0f) << 004; \
	l4f1_c = (l4f1_c & 0xcccccccc) >> 002 | (l4f1_c & 0x33333333) << 002; \
    }

#define l2_1_reverse(l4f1_c) \
    {									      \
	l2_1_reverse_1up(l4f1_c);					      \
	l4f1_c = (l4f1_c & 0xaaaaaaaa) >> 001 | (l4f1_c & 0x55555555) << 001; \
    }

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
#else
# define l2_2_reverse_1up(l4f1_c) \
    {									      \
	l4f1_c = l4f1_c >> 040 | l4f1_c << 040;				      \
	l4f1_c = (l4f1_c & 0xffff0000ffff0000ul) >> 020			      \
	    | (l4f1_c & 0x0000ffff0000fffful) << 020;			      \
	l4f1_c = (l4f1_c & 0xff00ff00ff00ff00ul) >> 010			      \
	    | (l4f1_c & 0x00ff00ff00ff00fful) << 010;			      \
	l4f1_c = (l4f1_c & 0xf0f0f0f0f0f0f0f0ul) >> 004			      \
	    | (l4f1_c & 0x0f0f0f0f0f0f0f0ful) << 004;			      \
	l4f1_c = (l4f1_c & 0xccccccccccccccccul) >> 002			      \
	    | (l4f1_c & 0x3333333333333333ul) << 002;			      \
    }
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
#else
# define l2_2_reverse(l4f1_c) \
    {									      \
	l2_2_reverse_1up(l4f1_c);					      \
	l4f1_c = (l4f1_c & 0xaaaaaaaaaaaaaaaaul) >> 001			      \
	    | (l4f1_c & 0x5555555555555555ul) << 001;			      \
    }
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#if SIZEOF_VOID_P == SIZEOF_UNSIGNED
# define l2_q_reverse_1up(l4f1_c) \
    l2_1_reverse_1up((l4f1_c))
#else
# define l2_q_reverse_1up(l4f1_c) \
    l2_2_reverse_1up((l4f1_c))
#endif				/* SIZEOF_VOID_P == SIZEOF_UNSIGNED */

#if SIZEOF_VOID_P == SIZEOF_UNSIGNED
# define l2_q_reverse(l4f1_c) \
    l2_1_reverse((l4f1_c))
#else
# define l2_q_reverse(l4f1_c) \
    l2_2_reverse((l4f1_c))
#endif				/* SIZEOF_VOID_P == SIZEOF_UNSIGNED */

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
# define l2_2_reverse_1up(l4f1_c) \
    l2_1_reverse_1up((l4f1_c))
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#if SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED
# define l2_2_reverse(l4f1_c) \
    l2_1_reverse((l4f1_c))
#endif				/* SIZEOF_UNSIGNED_LONG == SIZEOF_UNSIGNED */

#endif				/* __LIBx1f4_reverse_H__ */
