/*
 * retain.h
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_retain_H__
#define __LIBx1f4_retain_H__

/*
 * select whether to retain _object_ embedded data
 *
 * initially data was retained (when objects were created).
 * It occurred later that that ain't smart for a number of reasons, including:
 *     .data was made available (returned) in a inconsistent fashion (when by
 *      non _object_ returning functions it was not retained, when by _object_
 *      returning functions it was).  Returned data (likely) was/is not to be
 *      retained, the reason it was was that _object_ data itself was not
 *      retainable, and thus _aime_ function _object_ arguments could not be
 *      retained.
 *     .retaining _object_ data requires all _object_ creators to know how to
 *      retain data - inconvenient at best.
 */
#define __RETAIN_OBJECT_DATA__		0

#endif				/* __LIBx1f4_retain_H__ */
