/*
 * qsce.7.c
 * Copyright (C) 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-defs.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define M_TEXT(___v, ___t) \
    ((void *) ((char *) (___v) + (___t)))

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

static int back_node
    (void *, unsigned, unsigned, void *, int (*) (void *, void *));
static int fast_node
    (struct fpnode_type *, unsigned, unsigned, unsigned, void *,
     int (*) (void *, void *));
static int jack_node
    (struct fpnode_type *, unsigned, unsigned, unsigned, void *,
     int (*) (void *, void *));
static int near_node
    (struct qsrate_type *, struct fpnode_type *, unsigned, unsigned, unsigned,
     unsigned, unsigned, void *, int (*) (void *, void *));

static int
back_node(void *node, unsigned pick, unsigned mall, void *back,
	  int (*call) (void *, void *))
{
    int delete;

    do {
	delete = call(back, node);
	if (delete) {
	    break;
	}

	pick--;

	node = (char *) node + mall;
    } while (pick);

    return delete;
}


static int
fast_node(struct fpnode_type *fpnode_data, unsigned line, unsigned zero,
	  unsigned mall, void *back, int (*call) (void *, void *))
{
    int delete = 0;

    for (; line; line--) {
	unsigned node;

	node = fpnode_data->node;
	if (node) {
	    delete = back_node(fpnode_data->star, node, mall, back, call);
	    if (delete) {
		break;
	    }
	}

	fpnode_data++;
    }

    return delete;
}


static int
jack_node(struct fpnode_type *fpnode_data, unsigned line, unsigned rate,
	  unsigned mall, void *back, int (*call) (void *, void *))
{
    int delete = 0,
	(*pick) (struct fpnode_type *, unsigned, unsigned, unsigned, void *,
		 int (*) (void *, void *));
    unsigned i;

    rate--;

    if (rate) {
	pick = jack_node;
    } else {
	pick = fast_node;
    }

    i = line;
    for (; i; i--) {
	if (fpnode_data->node) {
	    delete = pick
		(fpnode_data->star, line, rate, mall, back, call);
	    if (delete) {
		break;
	    }
	}

	fpnode_data++;
    }

    return delete;
}


static int
near_node(struct qsrate_type *qsrate_data, struct fpnode_type *fpnode_data,
	  unsigned size, unsigned lock, unsigned head, unsigned tail,
	  unsigned rate, void *back, int (*call) (void *, void *))
{
    int delete;

    if (lock) {
	struct fpnode_type *fpnode_text;
	unsigned part;

	fpnode_text = fpnode_data + lock;

	lock >>= 1;

	part = fpnode_text->call;

	if (head < part) {
	    delete = near_node
		(qsrate_data, fpnode_data, part, lock, head,
		 tail < part ? tail : part, rate, back, call);
	    if (delete) {
		tail = part;
	    }
	} else {
	    delete = 0;
	}

	if (part < tail) {
	    delete = near_node
		(qsrate_data, fpnode_text, size - part, lock,
		 head < part ? 0 : head - part, tail - part, rate, back, call);
	}
    } else {
	void *node;

	node = fpnode_data->star;

	if (rate) {
	    rate--;
	    if (head || tail < size) {
		delete = near_node
		    (qsrate_data, node, size,
		     1 << qsrate_data->link_a.fplist.lock >> 1, head, tail,
		     rate, back, call);
	    } else {
		if (rate) {
		    delete = jack_node
			(node, 1 << qsrate_data->link_a.fplist.lock, rate,
			 qsrate_data->link_a.fplist.mall, back, call);
		} else {
		    delete = fast_node
			(node, 1 << qsrate_data->link_a.fplist.lock, 0,
			 qsrate_data->link_a.fplist.mall, back, call);
		}
	    }
	} else {
	    unsigned mall;

	    mall = qsrate_data->link_a.fplist.mall;

	    node = M_TEXT(node, head * mall);
	    if (1) {
		delete = back_node(node, tail - head, mall, back, call);
	    }
	}
    }

    return delete;
}


int
x1f4_over_qsrate(void *qsrate, unsigned head, unsigned tail, void *back,
		 int (*call) (void *, void *))
{
    int status;
    unsigned size;

    tail++;

    size = qsrate(qsrate)->link_a.fplist.size;

    if (head < size && head < tail && tail < size + 1) {
	unsigned rate;
	void *node;

	node = qsrate(qsrate)->link_a.fplist.fpnode;

	rate = qsrate(qsrate)->link_a.fplist.rate;
	if (rate) {
	    status = near_node
		(qsrate, node, size,
		 1 << qsrate(qsrate)->link_a.fplist.lock >> 1, head, tail,
		 rate - 1, back, call);
	} else {
	    unsigned mall;

	    mall = qsrate(qsrate)->link_a.fplist.mall;

	    node = M_TEXT(node, head * mall);
	    if (1) {
		status = back_node(node, tail - head, mall, back, call);
	    }
	}
    } else {
	status = DECK_ERROR;
    }

    return status;
}
