/*
 * qscc.v.c
 * Copyright (C) 2010-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-config.h>

#include <stddef.h>
#include <string.h>

#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define M_TEXT(___v, ___t) \
    ((void *) ((char *) (___v) + (___t)))

#define true(e)				1

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

#if __DELAY_MERGE__
int
_libx1f4l2_long_qsrate(void *qsrate, unsigned *near,
		       struct fpnode_type *fpnode_line,
		       struct fpnode_type *fpnode_data, unsigned index,
		       void *dhmiss)
#else
int
_libx1f4l2_long_qsrate(void *qsrate, unsigned *near,
		       struct fpnode_type *fpnode_line,
		       struct fpnode_type *fpnode_data, unsigned index)
#endif				/* __DELAY_MERGE__ */
{
    int status = 0;

    if (fpnode_line == qsrate(qsrate)->link_a.fplist.fpnode) {
#if __DELAY_MERGE__
	status = _libx1f4l2_trap_qsrate
	    (qsrate, near, fpnode_line, fpnode_data, index, dhmiss);
#else
	status = _libx1f4l2_trap_qsrate
	    (qsrate, near, fpnode_line, fpnode_data, index);
#endif				/* __DELAY_MERGE__ */
    } else {
	unsigned call, line;

	line = qsrate(qsrate)->link_a.fplist.line;

#if __DELAY_MERGE__
      label:
#endif				/* __DELAY_MERGE__ */
	call = fpnode_data - fpnode_line;
	if (call & 1) {
	    unsigned mind;

	    mind = (fpnode_data - 1)->node;
	    if (true(mind)) {
		unsigned seek;

		line >>= 1;

		seek = mind - line;
		if (seek) {
		    unsigned mall;
		    void *fpnode, *fqnode;

		    mall = qsrate(qsrate)->link_a.fplist.mall;

		    fpnode = (fpnode_data - 0)->star;
		    fqnode = (fpnode_data - 1)->star;

		    if (2 < seek) {
			seek++;
			seek >>= 1;
			memmove(M_TEXT(fpnode, (seek + index) * mall),
				M_TEXT(fpnode, (index + 1) * mall),
				(line - index - 1) * mall);
			memmove(M_TEXT(fpnode, seek * mall), fpnode,
				index * mall);
			mind -= seek;
			memcpy(fpnode, M_TEXT(fqnode, mind * mall),
			       seek * mall);
			fpnode_data->node = line + seek - 1;
		    } else {
			memmove(M_TEXT(fpnode, mall), fpnode, index * mall);
			mind--;
			memcpy(fpnode, M_TEXT(fqnode, mind * mall), mall);
		    }

		    (fpnode_data - 0)->call = mind;
		    (fpnode_data - 1)->node = mind;
		} else {
#if __DELAY_MERGE__
		    int excess;
#else
# define excess				status
#endif				/* __DELAY_MERGE__ */
		    unsigned mall;
		    void *fpnode, *fqnode;

		    mall = qsrate(qsrate)->link_a.fplist.mall;

		    fpnode = (fpnode_data - 0)->star;
		    fqnode = (fpnode_data - 1)->star;

		    if (0) {
		    } else {
			memcpy(M_TEXT(fqnode, mall * line), fpnode,
			       index * mall);
			memcpy(M_TEXT(fqnode, mall * (line + index)),
			       M_TEXT(fpnode, (index + 1) * mall),
			       (line - index - 1) * mall);
		    }

		    mind <<= 1;
		    mind--;

		    (fpnode_data - 0)->call = mind;
		    (fpnode_data - 1)->node = mind;

		    excess = _libx1f4l2_beta_qsrate
			(qsrate, near, fpnode_line, call);
#if __DELAY_MERGE__
		    if (excess) {
			if (status) {
			} else {
			    status = excess;
			}
		    }
#endif				/* __DELAY_MERGE__ */

#if __DELAY_MERGE__
#else
# undef excess
#endif				/* __DELAY_MERGE__ */
		}
	    } else {
	    }
	} else {
	    unsigned mind;

	    mind = (fpnode_data + 1)->node;
	    if (mind) {
		unsigned seek;

		line >>= 1;

		seek = mind - line;
		if (seek) {
		    unsigned mall, rail;
		    void *fpnode, *fqnode;

		    mall = qsrate(qsrate)->link_a.fplist.mall;

		    fpnode = (fpnode_data + 0)->star;
		    fqnode = (fpnode_data + 1)->star;

		    fpnode = M_TEXT(fpnode, index * mall);
		    rail = (line - index - 1) * mall;
		    memmove(fpnode, M_TEXT(fpnode, mall), rail);
		    fpnode = M_TEXT(fpnode, rail);
		    if (2 < seek) {
			seek++;
			seek >>= 1;
			memcpy(fpnode, fqnode, seek * mall);
			mind -= seek;
			memmove(fqnode, M_TEXT(fqnode, seek * mall),
				mind * mall);
			rail = line + seek - 1;
			(fpnode_data + 0)->node = rail;
			(fpnode_data + 1)->call = rail;
		    } else {
			memcpy(fpnode, fqnode, mall);
			mind--;
			memmove(fqnode, M_TEXT(fqnode, mall), mind * mall);
			(fpnode_data + 1)->call = line;
		    }

		    (fpnode_data + 1)->node = mind;
		} else {
#if __DELAY_MERGE__
		    int excess;
#else
# define excess				status
#endif				/* __DELAY_MERGE__ */
		    unsigned mall;
		    void *fpnode, *fqnode;

		    mall = qsrate(qsrate)->link_a.fplist.mall;

		    fpnode = (fpnode_data + 0)->star;
		    fqnode = (fpnode_data + 1)->star;

		    if (0) {
		    } else {
			memmove(M_TEXT(fpnode, index * mall),
				M_TEXT(fpnode, (index + 1) * mall),
				(line - 1 - index) * mall);
			memcpy(M_TEXT(fpnode, (line - 1) * mall), fqnode,
			       line * mall);
		    }

		    mind <<= 1;
		    mind--;

		    (fpnode_data + 0)->node = mind;
		    (fpnode_data + 1)->call = mind;

		    excess = _libx1f4l2_beta_qsrate
			(qsrate, near, fpnode_line, call + 1);
#if __DELAY_MERGE__
		    if (excess) {
			if (status) {
			} else {
			    status = excess;
			}
		    }
#endif				/* __DELAY_MERGE__ */

#if __DELAY_MERGE__
#else
# undef excess
#endif				/* __DELAY_MERGE__ */
		}
	    } else {
		if (call & 2) {
		    mind = (fpnode_data - 1)->node;
		    if (mind) {
			unsigned seek;

			line >>= 1;

			seek = mind - line;
			if (seek) {
			    unsigned mall;
			    void *fpnode, *fqnode;

			    mall = qsrate(qsrate)->link_a.fplist.mall;

			    fpnode = (fpnode_data - 0)->star;
			    fqnode = (fpnode_data - 1)->star;

			    if (2 < seek) {
				unsigned rail;

				seek++;
				seek >>= 1;
				memmove(M_TEXT(fpnode, (seek + index) * mall),
					M_TEXT(fpnode, (index + 1) * mall),
					(line - index - 1) * mall);
				memmove(M_TEXT(fpnode, seek * mall), fpnode,
					index * mall);
				mind -= seek;
				memcpy(fpnode, M_TEXT(fqnode, mind * mall),
				       seek * mall);
				rail = line + seek - 1;
				(fpnode_data - 0)->call -= seek;
				(fpnode_data + 0)->node = rail;
				(fpnode_data + 1)->call = rail;
			    } else {
				memmove(M_TEXT(fpnode, mall), fpnode,
					index * mall);
				mind--;
				memcpy(fpnode, M_TEXT(fqnode, mind * mall),
				       mall);
				(fpnode_data - 0)->call--;
				(fpnode_data + 1)->call = line;
			    }

			    (fpnode_data - 1)->node = mind;
			} else {
#if __DELAY_MERGE__
			    int excess;
#else
# define excess				status
#endif				/* __DELAY_MERGE__ */
			    unsigned mall;
			    void *fpnode, *fqnode;

			    mall = qsrate(qsrate)->link_a.fplist.mall;

			    fpnode = (fpnode_data - 0)->star;
			    fqnode = (fpnode_data - 1)->star;

			    if (0) {
			    } else {
				memcpy(M_TEXT(fqnode, mall * line), fpnode,
				       index * mall);
				memcpy(M_TEXT(fqnode, mall * (line + index)),
				       M_TEXT(fpnode, (index + 1) * mall),
				       (line - index - 1) * mall);
			    }

			    (fpnode_data - 0)->star = fqnode;
			    (fpnode_data - 1)->star = fpnode;

			    (fpnode_data - 0)->call -= mind;

			    mind <<= 1;
			    mind--;

			    (fpnode_data + 0)->node = mind;
			    (fpnode_data + 1)->call = mind;

			    excess = _libx1f4l2_beta_qsrate
				(qsrate, near, fpnode_line, call - 1);
#if __DELAY_MERGE__
			    if (excess) {
				if (status) {
				} else {
				    status = excess;
				}
			    }
#endif				/* __DELAY_MERGE__ */

#if __DELAY_MERGE__
#else
# undef excess
#endif				/* __DELAY_MERGE__ */
			}
		    } else {
			mind = (fpnode_data - 2)->node;
			if (true(mind)) {
			    unsigned seek;

			    line >>= 1;

			    seek = mind - line;
			    if (seek) {
				unsigned mall;
				void *fpnode, *fqnode;

				mall = qsrate(qsrate)->link_a.fplist.mall;

				fpnode = (fpnode_data - 0)->star;
				fqnode = (fpnode_data - 2)->star;

				if (2 < seek) {
				    unsigned rail;

				    seek++;
				    seek >>= 1;
				    memmove(M_TEXT(fpnode,
						   (seek + index) * mall),
					    M_TEXT(fpnode, (index + 1) * mall),
					    (line - index - 1) * mall);
				    memmove(M_TEXT(fpnode, seek * mall),
					    fpnode, index * mall);
				    mind -= seek;
				    memcpy(fpnode, M_TEXT(fqnode, mind * mall),
					   seek * mall);
				    rail = line + seek - 1;
				    (fpnode_data + 0)->node = rail;
				    (fpnode_data + 1)->call = rail;
				} else {
				    memmove(M_TEXT(fpnode, mall), fpnode,
					    index * mall);
				    mind--;
				    memcpy(fpnode, M_TEXT(fqnode, mind * mall),
					   mall);
				    (fpnode_data + 1)->call = line;
				}

				(fpnode_data - 0)->call = mind;
				(fpnode_data - 1)->call = mind;
				(fpnode_data - 2)->node = mind;
			    } else {
#if __DELAY_MERGE__
				if (((struct dhmiss_type *) dhmiss)->hook) {
				    int excess;
# if __STAMP_MERGE__
# else
				    unsigned mind = 0;
# endif				/* __STAMP_MERGE__ */

# if __STAMP_MERGE__
# else
				    if (index == fpnode_data->node - 1) {
					mind = 1;
				    }
# endif				/* __STAMP_MERGE__ */

				    line <<= 1;

# if __STAMP_MERGE__
				    excess = _libx1f4l2_type_qsrate
					(qsrate, dhmiss, &near, &fpnode_line,
					 &fpnode_data);
# else
				    excess = _libx1f4l2_type_qsrate
					(qsrate, dhmiss, mind, &near,
					 &fpnode_line, &fpnode_data);
# endif				/* __STAMP_MERGE__ */
				    if (excess) {
					if (status) {
					} else {
					    status = excess;
					}
				    }

				    ((struct dhmiss_type *) dhmiss)->hook =
					NULL;

				    goto label;
				}
#endif				/* __DELAY_MERGE__ */
				{
#if __DELAY_MERGE__
				    int excess;
#else
# define excess				status
#endif				/* __DELAY_MERGE__ */
				    unsigned mall;
				    void *fpnode, *fqnode;

				    mall = qsrate(qsrate)->link_a.fplist.mall;

				    fpnode = (fpnode_data - 0)->star;
				    fqnode = (fpnode_data - 2)->star;

				    if (0) {
				    } else {
					memcpy(M_TEXT(fqnode, mall * line),
					       fpnode, index * mall);
					memcpy(M_TEXT(fqnode,
						      mall * (line + index)),
					       M_TEXT(fpnode,
						      (index + 1) * mall),
					       (line - index - 1) * mall);
				    }

				    mind <<= 1;
				    mind--;

				    (fpnode_data + 1)->call = 0;
				    (fpnode_data - 0)->call = mind;
				    (fpnode_data - 1)->call = mind;
				    (fpnode_data - 2)->node = mind;

				    excess = _libx1f4l2_beta_qsrate
					(qsrate, near, fpnode_line, call);
#if __DELAY_MERGE__
				    if (excess) {
					if (status) {
					} else {
					    status = excess;
					}
				    }
#endif				/* __DELAY_MERGE__ */

#if __DELAY_MERGE__
#else
# undef excess
#endif				/* __DELAY_MERGE__ */
				}
			    }
			}
		    }
		} else {
		    mind = (fpnode_data + 2)->node;
		    if (true(mind)) {
			unsigned seek;

			line >>= 1;

			seek = mind - line;
			if (seek) {
			    unsigned mall, rail;
			    void *fpnode, *fqnode;

			    mall = qsrate(qsrate)->link_a.fplist.mall;

			    fpnode = (fpnode_data + 0)->star;
			    fqnode = (fpnode_data + 2)->star;

			    fpnode = M_TEXT(fpnode, index * mall);
			    rail = (line - index - 1) * mall;
			    memmove(fpnode, M_TEXT(fpnode, mall), rail);
			    fpnode = M_TEXT(fpnode, rail);
			    if (2 < seek) {
				seek++;
				seek >>= 1;
				memcpy(fpnode, fqnode, seek * mall);
				mind -= seek;
				memmove(fqnode, M_TEXT(fqnode, seek * mall),
					mind * mall);
				rail = line + seek - 1;
				(fpnode_data + 0)->node = rail;
				(fpnode_data + 1)->call = rail;
				(fpnode_data + 2)->call = rail;
			    } else {
				memcpy(fpnode, fqnode, mall);
				mind--;
				memmove(fqnode, M_TEXT(fqnode, mall),
					mind * mall);
				(fpnode_data + 1)->call = line;
				(fpnode_data + 2)->call = line;
			    }

			    (fpnode_data + 2)->node = mind;
			    (fpnode_data + 3)->call = mind;
			} else {
#if __DELAY_MERGE__
			    if (((struct dhmiss_type *) dhmiss)->hook) {
				int excess;
# if __STAMP_MERGE__
# else
				unsigned mind = 0;
# endif				/* __STAMP_MERGE__ */

# if __STAMP_MERGE__
# else
				if (index == fpnode_data->node - 1) {
				    mind = 1;
				}
# endif				/* __STAMP_MERGE__ */

				line <<= 1;

# if __STAMP_MERGE__
				excess = _libx1f4l2_type_qsrate
				    (qsrate, dhmiss, &near, &fpnode_line,
				     &fpnode_data);
# else
				excess = _libx1f4l2_type_qsrate
				    (qsrate, dhmiss, mind, &near, &fpnode_line,
				     &fpnode_data);
# endif				/* __STAMP_MERGE__ */
				if (excess) {
				    if (status) {
				    } else {
					status = excess;
				    }
				}

				((struct dhmiss_type *) dhmiss)->hook = NULL;

				goto label;
			    }
#endif				/* __DELAY_MERGE__ */
			    {
#if __DELAY_MERGE__
				int excess;
#else
# define excess				status
#endif				/* __DELAY_MERGE__ */
				unsigned mall;
				void *fpnode, *fqnode;

				mall = qsrate(qsrate)->link_a.fplist.mall;

				fpnode = (fpnode_data + 0)->star;
				fqnode = (fpnode_data + 2)->star;

				if (0) {
				} else {
				    memmove(M_TEXT(fpnode, index * mall),
					    M_TEXT(fpnode, (index + 1) * mall),
					    (line - 1 - index) * mall);
				    memcpy(M_TEXT(fpnode, (line - 1) * mall),
					   fqnode, line * mall);
				}

				mind <<= 1;
				mind--;

				(fpnode_data + 0)->node = mind;
				(fpnode_data + 1)->call = mind;
				(fpnode_data + 2)->call = mind;
				(fpnode_data + 3)->call = 0;

				excess = _libx1f4l2_beta_qsrate
				    (qsrate, near, fpnode_line, call + 2);
#if __DELAY_MERGE__
				if (excess) {
				    if (status) {
				    } else {
					status = excess;
				    }
				}
#endif				/* __DELAY_MERGE__ */

#if __DELAY_MERGE__
#else
# undef excess
#endif				/* __DELAY_MERGE__ */
			    }
			}
		    }
		}
	    }
	}
    }

    return status;
}
