/*
 * qscc.u.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-config.h>

#include <stddef.h>

#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define false(e)				0

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

static int near_last(struct fpnode_type *, unsigned);
static int near_post(struct fpnode_type *, unsigned);
static int pull_last(void **, unsigned *, unsigned *, unsigned,
		     struct fpnode_type *, struct fpnode_type *,
		     struct fpnode_type *);
static int pull_post(void **, unsigned *, unsigned *, unsigned,
		     struct fpnode_type *, struct qsrate_type *);
static int push_last(void *, unsigned, unsigned, unsigned,
		     struct fpnode_type *);
static int push_post(void *, unsigned, unsigned, struct fpnode_type *);
static int seek_last(struct fpnode_type *, unsigned, struct fpnode_type *);
static int seek_post(struct fpnode_type *, unsigned, struct fpnode_type *);

static int
near_last(struct fpnode_type *fpnode_line, unsigned line)
{
    struct fpnode_type *fpnode_slip;
    unsigned i;

    {
	fpnode_slip = fpnode_line;
    }
    i = line;
    for (--i; i; i--) {
	fpnode_line++;
	fpnode_slip += 2;
	*fpnode_line = *fpnode_slip;
    }

    return 0;
}


static int
near_post(struct fpnode_type *fpnode_line, unsigned line)
{
    struct fpnode_type *fpnode_slip;
    unsigned i;

    fpnode_line += line << 1;

    {
	fpnode_line--;
	fpnode_slip = fpnode_line;
	fpnode_slip--;
	*fpnode_line = *fpnode_slip;
    }
    i = line;
    for (--i; i; i--) {
	fpnode_line--;
	fpnode_slip -= 2;
	*fpnode_line = *fpnode_slip;
    }

    return 0;
}


static int
pull_last(void **node, unsigned *fast, unsigned *poke, unsigned line,
	  struct fpnode_type *fpnode_line, struct fpnode_type *fpnode_miss,
	  struct fpnode_type *fpnode_pick)
{
    fpnode_line += line << 1;
    fpnode_line--;

    if (fpnode_line->node) {
	unsigned pick, slip, text;

	pick = fpnode_pick - fpnode_miss;

	pick++;

	text = (fpnode_miss + pick)->call;

	slip = 1;
	while (slip & ~pick) {
	    text -= (fpnode_pick + 1 - slip)->call;
	    slip <<= 1;
	}

	slip = line;
	while (slip) {
	    text -= (fpnode_line + 1 - slip)->call;
	    slip >>= 1;
	}

	*node = (fpnode_line + 0)->star;
	*fast = (fpnode_line + 0)->node;
	*poke = text;

	fpnode_line->node = 0;
    } else {
	struct fpnode_type *fpnode_last;
	unsigned call, i, last, slip, text;

	text = (fpnode_line + 0)->call;

	fpnode_last = fpnode_line;

	fpnode_line--;

	*node = (fpnode_line + 0)->star;
	*fast = (fpnode_line + 0)->node;
	*poke = text;

	do {
	    fpnode_last -= 2;
	} while (!fpnode_last->node);

	last = (fpnode_line - fpnode_last) + 2;

	i = last >> 1;

	call = line;
	call--;
	call <<= 1;

	last = (line << 1) - last;

	for (--i; i; i--) {
	    fpnode_last = fpnode_line - 2;

	    text = (fpnode_last + 1)->call;

	    fpnode_line->node = fpnode_last->node;
	    fpnode_line->star = fpnode_last->star;

	    fpnode_line->call -= text;

	    slip = 2;
	    while (slip & ~call) {
		(fpnode_line + slip)->call += text;
		slip <<= 1;
	    }

	    fpnode_line++;

	    fpnode_line->call = text;

	    fpnode_line = fpnode_last;

	    call -= 2;
	}
	{
	    fpnode_last = fpnode_line - 1;

	    text = fpnode_line->call;

	    slip = 1;
	    do {
		text -= (fpnode_line - slip)->call;
		slip <<= 1;
	    } while (slip & ~call);

	    fpnode_line->node = fpnode_last->node;
	    fpnode_line->star = fpnode_last->star;

	    fpnode_last->node = 0;

	    fpnode_line->call -= text;

	    slip = 2;
	    while (slip & ~call) {
		(fpnode_line + slip)->call += text;
		slip <<= 1;
	    }

	    fpnode_line++;

	    fpnode_line->call = text;
	}
    }

    return 0;
}


static int
pull_post(void **node, unsigned *fast, unsigned *call, unsigned line,
	  struct fpnode_type *fpnode_line, struct qsrate_type *qsrate_data)
{
    unsigned slip, text;

    text = (fpnode_line + 1)->call;

    *node = (fpnode_line + 0)->star;
    *fast = (fpnode_line + 0)->node;
    *call = text;

    slip = 1;
    while (slip ^ line) {
	slip <<= 1;
	(fpnode_line + slip)->call -= text;
    }

    fpnode_line++;

    if (fpnode_line->node) {
	unsigned node;

	fpnode_line->call = (fpnode_line + 1)->call;

	node = fpnode_line->node;

	fpnode_line->node = 0;

	fpnode_line--;

	fpnode_line->node = node;
	fpnode_line->star = (fpnode_line + 1)->star;
    } else {
	struct fpnode_type *fpnode_post;
	unsigned call, i, post, slip;

	fpnode_post = fpnode_line;

	do {
	    fpnode_post += 2;
	} while (!fpnode_post->node);

	post = (fpnode_post - fpnode_line) + 1;

	fpnode_line--;

	call = 0;

	(fpnode_line + 1)->call = 0;

	i = post >> 1;
	for (; i; i--) {
	    fpnode_post = fpnode_line + 2;

	    text = (fpnode_post + 1)->call;

	    fpnode_line->node = fpnode_post->node;
	    fpnode_line->star = fpnode_post->star;

	    fpnode_line++;

	    fpnode_line->call = text;

	    fpnode_line = fpnode_post;

	    fpnode_line->call += text;

	    call += 2;

	    slip = 2;
	    while (slip & ~call) {
		(fpnode_line + slip)->call -= text;
		slip <<= 1;
	    }
	}
	{
	    fpnode_post = fpnode_line + 1;

	    call += 2;

	    if (call >> 1 ^ line) {
		text = (fpnode_post + 1)->call;

		slip = 2;
		while (slip & ~call) {
		    text -= (fpnode_post + 1 - slip)->call;
		    slip <<= 1;
		}
	    } else {
		struct fpnode_type *fpnode_miss;
		unsigned miss;

		miss = qsrate_data->link_a.fplist.line;

		text = 0;

		fpnode_miss = fpnode_post;
		while (miss < (fpnode_miss - 2)->call) {
		    unsigned half;

		    if (fpnode_miss->node) {
		    } else {
			break;
		    }

		    fpnode_miss = fpnode_miss->star;
		    half = line;
		    while (half) {
			fpnode_miss += half;
			text += fpnode_miss->call;
			half >>= 1;
		    }
		}

		text += fpnode_miss->node;
	    }

	    fpnode_line->node = fpnode_post->node;
	    fpnode_line->star = fpnode_post->star;

	    fpnode_post->call = text;
	    fpnode_post->node = 0;
	}
    }

    return 0;
}


static int
push_last(void *node, unsigned text, unsigned call, unsigned line,
	  struct fpnode_type *fpnode_line)
{
    unsigned slip;

    (fpnode_line + 1)->call = call;
    (fpnode_line + 1)->node = fpnode_line->node;
    (fpnode_line + 1)->star = fpnode_line->star;

    fpnode_line->node = text;
    fpnode_line->star = node;

    slip = 1;
    do {
	slip <<= 1;
	(fpnode_line + slip)->call += call;
    } while (slip ^ line);

    return 0;
}


static int
push_post(void *node, unsigned text, unsigned line,
	  struct fpnode_type *fpnode_line)
{
    fpnode_line += line << 1;
    fpnode_line--;

    fpnode_line->node = text;
    fpnode_line->star = node;

    return 0;
}


static int
seek_last(struct fpnode_type *fpnode_line, unsigned line,
	  struct fpnode_type *fpnode_slip)
{
    unsigned i;

    fpnode_line += line;

    i = line;
    for (; i; i--) {
	*fpnode_line = *fpnode_slip;
	fpnode_line++;
	fpnode_slip += 2;
    }

    return 0;
}


static int
seek_post(struct fpnode_type *fpnode_line, unsigned line,
	  struct fpnode_type *fpnode_slip)
{
    unsigned i;

    fpnode_line += line << 0;
    fpnode_slip += line << 1;

    i = line;
    for (; i; i--) {
	fpnode_line--;
	fpnode_slip -= 2;
	*fpnode_line = *fpnode_slip;
    }

    return 0;
}


int
_libx1f4l2_away_qsrate(void *qsrate, unsigned *near,
		       struct fpnode_type *fpnode_line,
		       struct fpnode_type *fpnode_data, unsigned *index,
		       unsigned **fail, void **fine)
{
    int status;
    struct fpnode_type *fpnode_last, *fpnode_post;
    unsigned call, last, line, post;

    line = 1 << qsrate(qsrate)->link_a.fplist.lock;

    call = fpnode_data - fpnode_line;

    fpnode_last = fpnode_data;

    fpnode_post = fpnode_data;

    if (near == &qsrate(qsrate)->link_a.fplist.node) {
	last = call;
	while (last) {
	    last--;
	    fpnode_last--;
	    if (fpnode_last->node) {
		break;
	    }
	}

	post = line - 1 - call;
	while (post) {
	    post--;
	    fpnode_post++;
	    if (fpnode_post->node) {
		break;
	    }
	}

	fpnode_data->node = 0;

	last = fpnode_last->node;

	post = fpnode_post->node;

	line >>= 1;

	fpnode_data->node = line;
    } else {
	if (call & 1) {
	    fpnode_last--;
	    last = fpnode_last->node;

	    if ((call + 1) ^ line) {
		fpnode_post++;
		post = fpnode_post->node;
	    } else {
		post = 0;
	    }

	    line >>= 1;
	} else {
	    if (call) {
		fpnode_last--;
		last = fpnode_last->node;

		fpnode_post++;
		post = fpnode_post->node;

		if (last) {
		    if (post) {
		    } else {
			if ((call + 2) ^ line) {
			    fpnode_post++;
			    post = fpnode_post->node;
			    if (last < post) {
			    } else {
				post = 0;
			    }
			}
		    }
		} else {
		    fpnode_last--;
		    last = fpnode_last->node;

		    if (post) {
			if (post < last) {
			} else {
			    last = 0;
			}
		    } else {
			if ((call + 2) ^ line) {
			    fpnode_post++;
			    post = fpnode_post->node;
			}
		    }
		}
	    } else {
		last = 0;

		fpnode_post++;
		post = fpnode_post->node;
		if (post) {
		} else {
		    fpnode_post++;
		    post = fpnode_post->node;
		}
	    }

	    line >>= 1;
	}
    }

    if (post < last) {
	if (line < last) {
	    unsigned flat, text;
	    void *node;

	    pull_last
		(&node, &text, &flat, line, fpnode_last->star, fpnode_line,
		 fpnode_last);
	    push_last(node, text, flat, line, fpnode_data->star);

	    *index += flat;

	    status = 0;

	    fpnode_data->node++;
	    fpnode_last->node--;

	    *fail = &fpnode_data->node;
	    *fine = fpnode_data->star;

	    if (near == &qsrate(qsrate)->link_a.fplist.node) {
		last = fpnode_last - fpnode_line;

		last++;
		do {
		    (fpnode_line + last)->call -= flat;
		    last += last & ~(last - 1);
		} while (last < line << 1);

		call++;
		while (call < line << 1) {
		    (fpnode_line + call)->call += flat;
		    call += call & ~(call - 1);
		}
	    } else {
		fpnode_data->call -= flat;

		if (call & 1) {
		} else {
		    unsigned slip;

		    last = fpnode_last - fpnode_line;

		    if (last & 1) {
		    } else {
			(fpnode_last + 1)->call -= flat;
		    }

		    slip = 1;
		    do {
			(fpnode_data + slip)->call += flat;
			slip <<= 1;
		    } while (slip & ~call);
		}
	    }
	} else {
	    unsigned slip, text;

	    last = fpnode_last - fpnode_line;

	    fpnode_last++;

	    text = fpnode_last->call;

	    if (last & 1) {
		last++;

		slip = 1;
		do {
		    text -= (fpnode_last - slip)->call;
		    slip <<= 1;
		} while (slip & ~last);

		last--;
	    }

	    fpnode_last--;

	    near_last(fpnode_last->star, line);
	    seek_last(fpnode_last->star, line, fpnode_data->star);

	    ((struct fpnode_type *) fpnode_last->star + line)->call = text;

	    if (near == &qsrate(qsrate)->link_a.fplist.node) {
		status = _libx1f4l2_else_qsrate
		    (qsrate, near, fpnode_line, fpnode_data, call, fpnode_last,
		     last, text, index, fail, fine);
	    } else {
		if (call & 1) {
		    if (false((call + 1) ^ line << 1)) {
		    } else {
			struct fpnode_type *fpnode_miss;
			unsigned miss;

			slip = 0;

			miss = qsrate(qsrate)->link_a.fplist.line;

			fpnode_miss = fpnode_data->star;
			while (1) {
			    unsigned half;

			    half = line;
			    while (half) {
				fpnode_miss += half;
				slip += fpnode_miss->call;
				half >>= 1;
			    }

			    if (fpnode_miss->node) {
				if (miss < fpnode_miss->call) {
				    fpnode_miss = fpnode_miss->star;
				} else {
				    break;
				}
			    } else {
				break;
			    }
			}

#if __DELAY_MERGE__
#else
			slip--;
#endif				/* __DELAY_MERGE__ */

			slip += fpnode_miss->node;
		    }

		    fpnode_data->call += slip;

		    fpnode_last->node = line << 1;

		    *index += text;

		    *fail = &fpnode_last->node;
		    *fine = fpnode_last->star;

		    status = _libx1f4l2_moon_qsrate
			(qsrate, near, fpnode_line, call);
		} else {
		    if (last & 1) {
			void *star;

			star = fpnode_data->star;

			fpnode_data->node = line << 1;
			fpnode_data->star = fpnode_last->star;

			fpnode_last->star = star;

			fpnode_data->call -= text;

			call++;

			slip = 1;
			do {
			    (fpnode_data + slip)->call += text;
			    slip <<= 1;
			} while (slip & ~call);

			call--;

			*index += text;

			*fail = &fpnode_data->node;
			*fine = fpnode_data->star;

			status = _libx1f4l2_moon_qsrate
			    (qsrate, near, fpnode_line, last);
		    } else {
			void *star;

			slip = (fpnode_data + 1)->call;

			(fpnode_data + 1)->call = 0;

			fpnode_data->call += slip;

			(fpnode_data - 1)->call += slip;

			fpnode_last->node = line << 1;

			*index += text;

			star = fpnode_last->star;

			status = _libx1f4l2_moon_qsrate
			    (qsrate, near, fpnode_line, call);
			if (star != fpnode_last->star) {
			    fpnode_last += 2;
			}

			*fail = &fpnode_last->node;
			*fine = star;
		    }
		}
	    }
	}
    } else {
	if (line < post) {
	    unsigned flat, text;
	    void *node;

	    pull_post(&node, &text, &flat, line, fpnode_post->star, qsrate);
	    push_post(node, text, line, fpnode_data->star);

	    post = fpnode_post - fpnode_line;

	    status = 0;

	    fpnode_data->node++;
	    fpnode_post->node--;

	    *fail = &fpnode_data->node;
	    *fine = fpnode_data->star;

	    if (near == &qsrate(qsrate)->link_a.fplist.node) {
		post++;
		while (post < line << 1) {
		    (fpnode_line + post)->call -= flat;
		    post += post & ~(post - 1);
		}

		call++;
		do {
		    (fpnode_line + call)->call += flat;
		    call += call & ~(call - 1);
		} while (call < line << 1);
	    } else {
		fpnode_post->call += flat;

		if (post & 1) {
		} else {
		    unsigned slip;

		    if (call & 1) {
		    } else {
			(fpnode_post - 1)->call += flat;
		    }

		    slip = 1;
		    do {
			(fpnode_post + slip)->call -= flat;
			slip <<= 1;
		    } while (slip & ~post);
		}
	    }
	} else {
	    unsigned slip, text;

	    fpnode_data++;

	    text = fpnode_data->call;

	    call++;

	    slip = 1;
	    while (slip & ~call) {
		text -= (fpnode_data - slip)->call;
		slip <<= 1;
	    }

	    call--;

	    fpnode_data--;

	    near_post(fpnode_post->star, line);
	    seek_post(fpnode_post->star, line, fpnode_data->star);

#if __DELAY_MERGE__
	    ((struct fpnode_type *) fpnode_post->star + line)->call = text;
#else
	    ((struct fpnode_type *) fpnode_post->star + line)->call = text + 1;
#endif				/* __DELAY_MERGE__ */

	    if (near == &qsrate(qsrate)->link_a.fplist.node) {
		status = _libx1f4l2_fair_qsrate
		    (qsrate, near, fpnode_line, fpnode_data, call, fpnode_post,
		     post, text, fail, fine);
	    } else {
		if (call & 1) {
		    fpnode_post->call -= text;

		    call++;

		    slip = 1;
		    do {
			(fpnode_post + slip)->call += text;
			slip <<= 1;
		    } while (slip & ~call);

		    call--;

		    *fail = &fpnode_post->node;
		    *fine = fpnode_post->star;

		    fpnode_post->node = line << 1;

		    status = _libx1f4l2_moon_qsrate
			(qsrate, near, fpnode_line, call);
		} else {
		    post = fpnode_post - fpnode_line;
		    if (post & 1) {
			void *star;

			star = fpnode_data->star;

			fpnode_data->node = line << 1;
			fpnode_data->star = fpnode_post->star;

			fpnode_post->star = star;

			call += 2;

			if (call >> 1 ^ line) {
			    fpnode_post++;

			    text = fpnode_post->call;

			    slip = 2;
			    while (slip & ~call) {
				text -= (fpnode_post - slip)->call;
				slip <<= 1;
			    }

			    fpnode_post--;
			} else {
			    struct fpnode_type *fpnode_miss;
			    unsigned miss;

			    miss = qsrate(qsrate)->link_a.fplist.line;

			    text = 0;

			    fpnode_miss = fpnode_data;
			    do {
				unsigned half;

				fpnode_miss = fpnode_miss->star;
				half = line;
				while (half) {
				    fpnode_miss += half;
				    text += fpnode_miss->call;
				    half >>= 1;
				}

				if (fpnode_miss->node) {
				} else {
				    break;
				}
			    } while (miss < fpnode_miss->call);

#if __DELAY_MERGE__
#else
			    text--;
#endif				/* __DELAY_MERGE__ */

			    text += fpnode_miss->node;
			}

			call -= 2;

			fpnode_post->call = text;

			*fail = &fpnode_data->node;
			*fine = fpnode_data->star;

			status = _libx1f4l2_moon_qsrate
			    (qsrate, near, fpnode_line, post);
		    } else {
			void *star;

			(fpnode_post - 1)->call = 0;

			fpnode_post->call -= text;

			call += 2;

			slip = 1;
			do {
			    (fpnode_post + slip)->call += text;
			    slip <<= 1;
			} while (slip & ~call);

			call -= 2;

			fpnode_post->node = line << 1;

			star = fpnode_post->star;

			status = _libx1f4l2_moon_qsrate
			    (qsrate, near, fpnode_line, call);
			if (star != fpnode_post->star) {
			    fpnode_post -= 2;
			}

			*fail = &fpnode_post->node;
			*fine = star;
		    }
		}
	    }
	}
    }

    return status;
}
