/*
 * qscc.t.c
 * Copyright (C) 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
_libx1f4l2_else_qsrate(void *qsrate, unsigned *near,
		       struct fpnode_type *fpnode_line,
		       struct fpnode_type *fpnode_data, unsigned call,
		       struct fpnode_type *fpnode_last, unsigned last,
		       unsigned text, unsigned *index, unsigned **fail,
		       void **fine)
{
    int status;

    status = qsrate(qsrate)->link_m.free
	(qsrate(qsrate)->link_m.data, fpnode_data->star);
    if (status) {
	status = FREE_ERROR;
    }

    if (1) {
	if (*near == 2) {
	    int excess;
	    void *node;

	    node = qsrate(qsrate)->link_a.fplist.fpnode;

	    qsrate(qsrate)->link_a.fplist.fpnode = fpnode_last->star;
	    qsrate(qsrate)->link_a.fplist.node =
		1 << qsrate(qsrate)->link_a.fplist.lock;

	    *fail = &qsrate(qsrate)->link_a.fplist.node;
	    *fine = fpnode_last->star;

	    excess = qsrate(qsrate)->link_m.free
		(qsrate(qsrate)->link_m.data, node);
	    if (excess) {
		if (status) {
		} else {
		    status = FREE_ERROR;
		}
	    }

	    *index += text;

	    node = qsrate(qsrate)->link_e.fplink_data;

	    qsrate(qsrate)->link_a.fplist.rate--;

	    qsrate(qsrate)->link_e.fplink_data =
		((struct fplink_type *) node)->fplink_data;

	    excess = qsrate(qsrate)->link_m.free
		(qsrate(qsrate)->link_m.data, node);
	    if (excess) {
		if (status) {
		} else {
		    status = FREE_ERROR;
		}
	    }
	} else {
	    unsigned line;

	    line = 1 << qsrate(qsrate)->link_a.fplist.lock;

	    fpnode_data->node = line;
	    fpnode_data->star = fpnode_last->star;

	    fpnode_last->node = 0;

	    *index += text;

	    (*near)--;

	    *fail = &fpnode_data->node;
	    *fine = fpnode_data->star;

	    last++;
	    do {
		(fpnode_line + last)->call -= text;
		last += last & ~(last - 1);
	    } while (last < line);

	    call++;
	    while (call < line) {
		(fpnode_line + call)->call += text;
		call += call & ~(call - 1);
	    }
	}
    }

    return status;
}
