/*
 * qscc.s.c
 * Copyright (C) 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
_libx1f4l2_fair_qsrate(void *qsrate, unsigned *near,
		       struct fpnode_type *fpnode_line,
		       struct fpnode_type *fpnode_data, unsigned call,
		       struct fpnode_type *fpnode_post, unsigned post,
		       unsigned text, unsigned **fail, void **fine)
{
    int status;

    status = qsrate(qsrate)->link_m.free
	(qsrate(qsrate)->link_m.data, fpnode_data->star);
    if (status) {
	status = FREE_ERROR;
    }

    if (1) {
	if (*near == 2) {
	    int excess;
	    void *node;

	    node = qsrate(qsrate)->link_a.fplist.fpnode;

	    qsrate(qsrate)->link_a.fplist.fpnode = fpnode_post->star;
	    qsrate(qsrate)->link_a.fplist.node =
		1 << qsrate(qsrate)->link_a.fplist.lock;

	    *fail = &qsrate(qsrate)->link_a.fplist.node;
	    *fine = fpnode_post->star;

	    excess = qsrate(qsrate)->link_m.free
		(qsrate(qsrate)->link_m.data, node);
	    if (excess) {
		if (status) {
		} else {
		    status = FREE_ERROR;
		}
	    }

	    node = qsrate(qsrate)->link_e.fplink_data;

	    qsrate(qsrate)->link_a.fplist.rate--;

	    qsrate(qsrate)->link_e.fplink_data =
		((struct fplink_type *) node)->fplink_data;

	    excess = qsrate(qsrate)->link_m.free
		(qsrate(qsrate)->link_m.data, node);
	    if (excess) {
		if (status) {
		} else {
		    status = FREE_ERROR;
		}
	    }
	} else {
	    unsigned line;

	    line = 1 << qsrate(qsrate)->link_a.fplist.lock;

	    fpnode_post->node = line;

	    fpnode_data->node = 0;

	    *fail = &fpnode_post->node;
	    *fine = fpnode_post->star;

	    (*near)--;

	    post = fpnode_post - fpnode_line;

	    post++;
	    while (post < line) {
		(fpnode_line + post)->call += text;
		post += post & ~(post - 1);
	    }

	    call++;
	    do {
		(fpnode_line + call)->call -= text;
		call += call & ~(call - 1);
	    } while (call < line);
	}
    }

    return status;
}
