/*
 * qscc.q.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
_libx1f4l2_rail_qsrate(void *qsrate, unsigned *trans, void **node,
		       unsigned *class)
{
    int status;

    status = _libx1f4l2_fall_qsrate(qsrate);
    if (status) {
    } else {
	struct fpnode_type *fpnode_data;
	unsigned count, flat, half, index;

	half = 1 << qsrate(qsrate)->link_a.fplist.lock >> 1;

	fpnode_data = qsrate(qsrate)->link_a.fplist.fpnode;

	index = *trans;

	flat = 3 * qsrate(qsrate)->link_a.fplist.line >> 2;

	if (flat < index) {
	    fpnode_data += half;

	    half >>= 1;

	    *trans = index - flat;
	}
	{
	    fpnode_data += half;

	    while (half) {
		fpnode_data->call++;
		half >>= 1;
		fpnode_data -= half;
	    }

	    fpnode_data--;

	    *node = fpnode_data->star;
	}

	count = fpnode_data->node;

	*class = count;

	fpnode_data->node = count + 1;

	qsrate(qsrate)->link_a.fplist.size = (flat << 1) + 1;
    }

    return status;
}
