/*
 * qscc.n.c
 * Copyright (C) 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-defs.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
_libx1f4l2_beta_qsrate(void *qsrate, unsigned *near,
		       struct fpnode_type *fpnode_line, unsigned call)
{
    int status;
    struct fpnode_type *fpnode_data;

    fpnode_data = fpnode_line + call;

    (*near)--;

    status = qsrate(qsrate)->link_m.free
	(qsrate(qsrate)->link_m.data, fpnode_data->star);
    if (status) {
	status = FREE_ERROR;
    }

    if (1) {
	fpnode_data->node = 0;

	if (call & 1) {
	} else {
	    struct fpnode_type *fpnode_last, *fpnode_post;
	    unsigned last = ~0, line, mind, post = ~0, slip, text;

	    line = 1 << qsrate(qsrate)->link_a.fplist.lock;

	    fpnode_last = fpnode_data;
	    fpnode_post = fpnode_data;

	    mind = call >> 1;
	    slip = (line - call) >> 1;

	    if (0) {
	    } else {
		fpnode_last -= 1;
		fpnode_post += 1;
	    }

	    text = mind < slip ? mind : slip;
	    while (text) {
		if (fpnode_post->node) {
		    post = fpnode_post - fpnode_line;
		    if (1) {
			break;
		    }
		} else {
		    fpnode_post += 2;
		}
		if (fpnode_last->node) {
		    last = fpnode_last - fpnode_line;
		    if (1) {
			break;
		    }
		} else {
		    fpnode_last -= 2;
		}

		text--;
	    }

	    if (text) {
	    } else {
		if (mind < slip) {
		    slip -= mind;
		    for (; slip; slip--) {
			if (fpnode_post->node) {
			    post = fpnode_post - fpnode_line;
			    if (1) {
				break;
			    }
			} else {
			    fpnode_post += 2;
			}
		    }
		} else {
		    mind -= slip;
		    for (; mind; mind--) {
			if (fpnode_last->node) {
			    last = fpnode_last - fpnode_line;
			    if (1) {
				break;
			    }
			} else {
			    fpnode_last -= 2;
			}
		    }
		}
	    }

	    if (~last) {
		unsigned i;

		i = (call - last) >> 1;
		for (; i; i--) {
		    fpnode_last = fpnode_data - 2;

		    text = fpnode_last->node;

		    fpnode_data->node = text;
		    fpnode_data->star = fpnode_last->star;

		    fpnode_data->call -= text;

		    slip = 2;
		    while (slip & ~call) {
			(fpnode_data + slip)->call += text;
			slip <<= 1;
		    }

		    fpnode_data++;

		    fpnode_data->call = text;

		    fpnode_data = fpnode_last;

		    call -= 2;
		}
		{
		    fpnode_last = fpnode_data - 1;

		    text = fpnode_last->node;

		    fpnode_data->node = text;
		    fpnode_data->star = fpnode_last->star;

		    fpnode_last->node = 0;

		    fpnode_data->call -= text;

		    slip = 2;
		    while (slip & ~call) {
			(fpnode_data + slip)->call += text;
			slip <<= 1;
		    }

		    fpnode_data++;

		    fpnode_data->call = text;
		}
	    } else {
		unsigned i;

		i = (post - call) >> 1;
		for (; i; i--) {
		    fpnode_post = fpnode_data + 2;

		    text = fpnode_post->node;

		    fpnode_data->node = text;
		    fpnode_data->star = fpnode_post->star;

		    fpnode_data++;

		    fpnode_data->call = text;

		    fpnode_data = fpnode_post;

		    fpnode_data->call += text;

		    call += 2;

		    slip = 2;
		    while (slip & ~call) {
			(fpnode_data + slip)->call -= text;
			slip <<= 1;
		    }
		}
		{
		    fpnode_post = fpnode_data + 1;

		    text = fpnode_post->node;

		    fpnode_data->node = text;
		    fpnode_data->star = fpnode_post->star;

		    fpnode_post->call = text;
		    fpnode_post->node = 0;
		}
	    }
	}
    }

    return status;
}
