/*
 * qscc.g.c
 * Copyright (C) 2010-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-config.h>

#include <stddef.h>

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define false(e)				0

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

#if __DELAY_MERGE__
# if __STAMP_MERGE__
int
_libx1f4l2_type_qsrate(void *qsrate, void *dhmiss, unsigned **type,
		       struct fpnode_type **flnode,
		       struct fpnode_type **fnnode)
# else
int
_libx1f4l2_type_qsrate(void *qsrate, void *dhmiss, unsigned mind,
		       unsigned **type, struct fpnode_type **flnode,
		       struct fpnode_type **fnnode)
# endif				/* __STAMP_MERGE__ */
{
    int status = 0;
    struct dhmiss_type *dhmiss_data;
    struct fpnode_type *fpnode_data;
    unsigned index, lock, *near, rate;
# if __STAMP_MERGE__
    unsigned slip;
# endif				/* __STAMP_MERGE__ */
    void *node;

    lock = qsrate(qsrate)->link_a.fplist.lock;

    dhmiss_data = dhmiss;

    near = dhmiss_data->meta;
    node = dhmiss_data->hook;
    rate = dhmiss_data->late;

# if __STAMP_MERGE__
# else
    index = dhmiss_data->black;
# endif				/* __STAMP_MERGE__ */

    fpnode_data = dhmiss_data->side;

# if __STAMP_MERGE__
    lock = 1 << lock;
# endif				/* __STAMP_MERGE__ */

# if __STAMP_MERGE__
    slip = *fnnode - *flnode;
# endif				/* __STAMP_MERGE__ */

# if __STAMP_MERGE__
# else
    index -= mind;
# endif				/* __STAMP_MERGE__ */

    do {
	int excess;
# if __STAMP_MERGE__
	unsigned text;
# endif				/* __STAMP_MERGE__ */

# if __STAMP_MERGE__
	index = 0;
# endif				/* __STAMP_MERGE__ */

# if __STAMP_MERGE__
	text = ((struct fpnode_type *) fpnode_data->star)->call;
# endif				/* __STAMP_MERGE__ */

	excess = _libx1f4l2_away_qsrate
	    (qsrate, near, node, fpnode_data, &index, &near, &node);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}

	rate--;

# if __STAMP_MERGE__
	{
	    unsigned back;

	    back = rate ? text : slip;
	    if (*near == lock) {
		back >>= 1;
		if (index) {
		    back += lock >> 1;
		} else {
		}
	    } else {
		if (back) {
		    if (false(back == lock - 1)) {
			back--;
		    } else {
		    }
		} else {
		    if (index) {
			back = 1;
		    } else {
		    }
		}
	    }

	    fpnode_data = node;
	    fpnode_data += back;
	}
# else
	{
	    unsigned *cell;
	    unsigned half;

	    fpnode_data = node;

	    half = lock;

	    cell = &fpnode_data->call;

#  if 0
	    while (3 < half) {
		unsigned *call, news, sail;

		sail = sizeof(struct fpnode_type) << half;

		sail >>= 1;
		call = (void *) ((char *) cell + sail);

		news = *call;
		if (index < news) {
		} else {
		    index -= news;
		    cell = call;
		}

		sail >>= 1;
		call = (void *) ((char *) cell + sail);

		news = *call;
		if (index < news) {
		} else {
		    index -= news;
		    cell = call;
		}

		sail >>= 1;
		call = (void *) ((char *) cell + sail);

		news = *call;
		if (index < news) {
		} else {
		    index -= news;
		    cell = call;
		}

		sail >>= 1;
		call = (void *) ((char *) cell + sail);

		news = *call;
		if (index < news) {
		} else {
		    index -= news;
		    cell = call;
		}

		half -= 4;
	    }
#  endif
	    while (half) {
		unsigned *call, news;

		half--;

		call = (void *)
		    ((char *) cell
		     + (sizeof(struct fpnode_type) << half));

		news = *call;
		if (index < news) {
		} else {
		    index -= news;
		    cell = call;
		}
	    }

	    fpnode_data = (void *)
		((char *) cell - offsetof(struct fpnode_type, call));
	}
# endif				/* __STAMP_MERGE__ */
    } while (rate);

    *type = near;
    *flnode = node;
    *fnnode = fpnode_data;

    return status;
}
#endif				/* __DELAY_MERGE__ */
