/*
 * qscc.f.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <mask.0.h>
#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>
#include <trans.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

static int init_list(struct qsrate_type *, unsigned, unsigned);

static int
init_list(struct qsrate_type *qsrate_data, unsigned mall, unsigned lock)
{
    int status;
    void *data;

#if __MICRO_RATES__
    while (~lock & 2) {
	lock >>= 1;
    }
#endif				/* __MICRO_RATES__ */

    status = qsrate_data->link_m.link
	(qsrate_data->link_m.data, &data, mall * 3 * lock >> 1);
    if (status) {
	status = LINK_ERROR;
    } else {
	qsrate_data->link_a.fplist.fpnode = data;
    }

    return status;
}


int
x1f4_fast_qsrate(void *qsrate, unsigned flags,
		 struct screen_type *screen_data)
{
    int status;
    unsigned line, lock, mall;

    mall = screen_data->size;

    line = TEXT_LINE;
    if (flags & HALF_FRAME) {
	line = screen_data->half << 2;
    }

    lock = TEXT_RATE;
    if (flags & RATE_FRAME) {
	lock = screen_data->rate;
    }

    if ((int) lock < 4) {
	/*
	 * improper error code, should invent another
	 */
	status = DECK_ERROR;
    } else {
	if (flags & TRANS_MASK) {
	    struct trans_type *trans_data;

	    trans_data = screen_data->trans_data;

	    qsrate(qsrate)->link_m.data = trans_data->data;
	    qsrate(qsrate)->link_m.free = trans_data->free;
	    qsrate(qsrate)->link_m.link = trans_data->link;
	    qsrate(qsrate)->link_m.mode = trans_data->mode;
	} else {
	    qsrate(qsrate)->link_m.free = _libx1f4l2_free_data;
	    qsrate(qsrate)->link_m.link = _libx1f4l2_link_data;
	    qsrate(qsrate)->link_m.mode = _libx1f4l2_mode_data;
	}

	status = init_list(qsrate, mall, line);
	if (status) {
	} else {
	    qsrate(qsrate)->link_a.fplist.line = line;
	    qsrate(qsrate)->link_a.fplist.lock = lock;
	    qsrate(qsrate)->link_a.fplist.mall = mall;

	    qsrate(qsrate)->link_a.fplist.node = 0;
	    qsrate(qsrate)->link_a.fplist.rate = 0;
	    qsrate(qsrate)->link_a.fplist.size = 0;

	    qsrate(qsrate)->link_e.fplink_data = NULL;
	    qsrate(qsrate)->link_e.fplink_text = NULL;
	}
    }

    return status;
}
