/*
 * qscc.d.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <qscc-names.h>
#include <qscc-types.h>

#if SIZEOF_UNSIGNED_LONG & (SIZEOF_UNSIGNED_LONG - 1)
# define __case_node__			0
#else
# define __case_node__			1
#endif				/* SIZEOF_UNSIGNED_LONG & (SIZEOF_UNSIGNE... */

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

static void back_node(void *, unsigned, unsigned);
#if __case_node__
static void case_node(void *, unsigned, unsigned);
#endif				/* __case_node__ */
static void fast_node
    (struct fpnode_type *, unsigned, unsigned, unsigned, unsigned,
     void (*) (void *, unsigned, unsigned));
static void jack_node
    (struct fpnode_type *, unsigned, unsigned, unsigned, unsigned,
     void (*) (void *, unsigned, unsigned));
static void long_node
    (struct fpnode_type *, unsigned, unsigned, unsigned, unsigned, unsigned,
     void (*) (void *, unsigned, unsigned));

static void
back_node(void *node, unsigned pick, unsigned mall)
{
    void *slip;

    slip = (char *) node + pick * mall;

    pick >>= 1;
    for (; pick; pick--) {
	char *away, *line;
	unsigned i;

	away = slip;
	line = node;

	away -= mall;

	slip = away;

	i = mall;
	for (; i; i--) {
	    char c;

	    c = *away;
	    *away++ = *line;
	    *line++ = c;
	}

	node = line;
    }
}


#if __case_node__
static void
case_node(void *node, unsigned pick, unsigned mall)
{
    void *slip;

    slip = (unsigned long *) node + pick * mall;

    pick >>= 1;
    for (; pick; pick--) {
	unsigned i;
	unsigned long *away, *line;

	away = slip;
	line = node;

	away -= mall;

	slip = away;

	i = mall;
	for (; i; i--) {
	    unsigned long c;

	    c = *away;
	    *away++ = *line;
	    *line++ = c;
	}

	node = line;
    }
}
#endif				/* __case_node__ */


static void
fast_node(struct fpnode_type *fpnode_data, unsigned lock, unsigned size,
	  unsigned rate, unsigned mall,
	  void (*flip) (void *, unsigned, unsigned))
{
    struct fpnode_type *fpnode_mind;
    unsigned line;

    line = 1 << lock;

    fpnode_mind = fpnode_data + line;

    line >>= 1;

    if (rate) {
	long_node(fpnode_data, line, lock, size, rate - 1, mall, flip);
    } else {
	jack_node(fpnode_data, line, lock, size, mall, flip);
    }

    for (--line; line; line--) {
	unsigned call;

	fpnode_data++;
	fpnode_mind--;

	call = fpnode_data->call;
	fpnode_data->call = fpnode_mind->call;
	fpnode_mind->call = call;
    }

    fpnode_data--;
    fpnode_mind--;

    line = 1 << lock >> 2;
    for (; line; line--) {
	unsigned ns_0, ns_1, nx_0, nx_1;
	void *sv_0, *sv_1, *sz_0, *sz_1;

	ns_0 = fpnode_data->node;
	sv_0 = fpnode_data->star;
	fpnode_data++;
	ns_1 = fpnode_data->node;
	sv_1 = fpnode_data->star;

	nx_0 = fpnode_mind->node;
	sz_0 = fpnode_mind->star;
	fpnode_mind++;
	nx_1 = fpnode_mind->node;
	sz_1 = fpnode_mind->star;

	if (nx_1) {
	    fpnode_data->node = nx_0;
	    fpnode_data->star = sz_0;
	    fpnode_data--;
	    fpnode_data->node = nx_1;
	    fpnode_data->star = sz_1;
	} else {
	    fpnode_data->node = nx_1;
	    fpnode_data->star = sz_1;
	    fpnode_data--;
	    fpnode_data->node = nx_0;
	    fpnode_data->star = sz_0;
	}

	if (ns_1) {
	    fpnode_mind->node = ns_0;
	    fpnode_mind->star = sv_0;
	    fpnode_mind--;
	    fpnode_mind->node = ns_1;
	    fpnode_mind->star = sv_1;
	} else {
	    fpnode_mind->node = ns_1;
	    fpnode_mind->star = sv_1;
	    fpnode_mind--;
	    fpnode_mind->node = ns_0;
	    fpnode_mind->star = sv_0;
	}

	fpnode_data -= 2;
	fpnode_mind += 2;
    }
}


static void
jack_node(struct fpnode_type *fpnode_data, unsigned line, unsigned lock,
	  unsigned size, unsigned mall,
	  void (*flip) (void *, unsigned, unsigned))
{
    struct fpnode_type *fpnode_mind;
    unsigned half;

    fpnode_mind = fpnode_data + line;

    line >>= 1;

    half = fpnode_mind->call;

    size -= half;

    if (line) {
	jack_node(fpnode_data, line, lock, half, mall, flip);

	fpnode_mind->call = size;

	jack_node(fpnode_mind, line, lock, size, mall, flip);
    } else {
	if (half) {
	    flip(fpnode_data->star, half, mall);
	}

	if (size) {
	    fpnode_mind->call = size;

	    flip(fpnode_mind->star, size, mall);
	}
    }
}


static void
long_node(struct fpnode_type *fpnode_data, unsigned line, unsigned lock,
	  unsigned size, unsigned rate, unsigned mall,
	  void (*flip) (void *, unsigned, unsigned))
{
    struct fpnode_type *fpnode_mind;
    unsigned half;

    fpnode_mind = fpnode_data + line;

    line >>= 1;

    half = fpnode_mind->call;

    size -= half;

    if (line) {
	long_node(fpnode_data, line, lock, half, rate, mall, flip);

	fpnode_mind->call = size;

	long_node(fpnode_mind, line, lock, size, rate, mall, flip);
    } else {
	if (half) {
	    fast_node(fpnode_data->star, lock, half, rate, mall, flip);
	}

	if (size) {
	    fpnode_mind->call = size;

	    fast_node(fpnode_mind->star, lock, size, rate, mall, flip);
	}
    }
}


int
x1f4_flip_qsrate(void *qsrate)
{
    unsigned mall, rate;
    void (*flip) (void *, unsigned, unsigned), *node;

    node = qsrate(qsrate)->link_a.fplist.fpnode;

    mall = qsrate(qsrate)->link_a.fplist.mall;

    rate = qsrate(qsrate)->link_a.fplist.rate;

#if __case_node__
    if (mall & (SIZEOF_UNSIGNED_LONG - 1)) {
#endif				/* __case_node__ */
	flip = back_node;
#if __case_node__
    } else {
	flip = case_node;
	mall /= SIZEOF_UNSIGNED_LONG;
    }
#endif				/* __case_node__ */

    if (rate) {
	fast_node
	    (node, qsrate(qsrate)->link_a.fplist.lock,
	     qsrate(qsrate)->link_a.fplist.size, rate - 1, mall, flip);
    } else {
	unsigned size;

	size = qsrate(qsrate)->link_a.fplist.size;
	if (size) {
	    flip(node, size, mall);
	} else {
	}
    }

    return 0;
}
