/*
 * qscc.8.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <qscc-defs.h>
#include <qscc-inter.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

int
x1f4_high_qsrate(void *qsrate)
{
    int status;

    status = _libx1f4l2_ceil_qsrate(qsrate);
    if (status) {
    } else {
	qsrate(qsrate)->link_e.fplink_data = NULL;
	qsrate(qsrate)->link_e.fplink_text = NULL;

	qsrate(qsrate)->link_a.fplist.size = 0;

	if (qsrate(qsrate)->link_a.fplist.rate) {
	    void *data;

	    data = qsrate(qsrate)->link_a.fplist.fpnode;

	    status = qsrate(qsrate)->link_m.mode
		(qsrate(qsrate)->link_m.data, &data,
		 qsrate(qsrate)->link_a.fplist.mall * 3
		 * qsrate(qsrate)->link_a.fplist.line >> 1);
	    if (status) {
		status = MODE_ERROR;
	    } else {
		qsrate(qsrate)->link_a.fplist.rate = 0;
		if (1) {
		    qsrate(qsrate)->link_a.fplist.fpnode = data;
		}
	    }
	}
    }

    return status;
}
