/*
 * qscc-types.h
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_qscc_types_H__
#define __LIBx1f4_qscc_types_H__

#include <qscc-config.h>

#include <trans.h>

#if __DELAY_MERGE__
typedef struct dhmiss_type {
# if __STAMP_MERGE__
# else
    unsigned black;
# endif				/* __STAMP_MERGE__ */
    unsigned late, *meta;
    void *hook, *side;
} dhmiss_type;
#endif				/* __DELAY_MERGE__ */

typedef struct fplink_type {
    struct fplink_type *fplink_data;
} fplink_type;

typedef struct fpnode_type {
    unsigned call, node;
    void *star;
} fpnode_type;

typedef struct fplist_type {
    unsigned line, lock, mall, node, rate, size;
    void *fpnode;
} fplist_type;

typedef struct screen_type {
    unsigned half, rate, size;
    struct trans_type *trans_data;
} screen_type;

typedef struct qsrate_type {
    struct {
	struct fplist_type fplist;
    } link_a;
    struct {
	struct fplink_type *fplink_data, *fplink_text;
    } link_e;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
} qsrate_type;

#endif				/* __LIBx1f4_qscc_types_H__ */
