/*
 * qscb.n.c
 * Copyright (C) 2010-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <qscc-config.h>

#include <stddef.h>

#include <qscc-defs.h>
#include <qscc-names.h>
#include <qscc-types.h>

#define qsrate(qsrate)			((struct qsrate_type *) (qsrate))

static int back_data(struct qsrate_type *);
static int back_line(void *, unsigned, unsigned, int (*) (void *, void *),
		     void *);
static int back_rate(struct qsrate_type *, struct fpnode_type *, unsigned,
		     unsigned, int (*) (void *, void *), void *);
static int back_text(struct qsrate_type *);
static int ever_line(void *, void *, unsigned, unsigned,
		     int (*) (void *, void *, const void *),
		     int (*) (void *, void *), void *);
static int fine_data(struct qsrate_type *, unsigned);
static int fine_text(struct qsrate_type *);
static int type_line(struct qsrate_type *, struct fpnode_type *,
		     struct fpnode_type *, unsigned, unsigned,
		     int (*) (void *, void *, const void *),
		     int (*) (void *, void *), void *);

static int
back_data(struct qsrate_type *qsrate_data)
{
    void *land;

    land = qsrate_data->link_e.fplink_data;

    qsrate_data->link_e.fplink_data = NULL;

    while (land) {
	struct fplink_type *fplink_data;

	fplink_data = ((struct fplink_type *) land)->fplink_data;

	qsrate_data->link_m.free(qsrate_data->link_m.data, land);

	land = fplink_data;
    }

    return -1;
}


static int
back_line(void *data, unsigned size, unsigned mall,
	  int (*free) (void *, void *), void *context)
{
    for (; size; size--) {
	free(context, data);
	data = (char *) data + mall;
    }

    return -1;
}


static int
back_rate(struct qsrate_type *qsrate_data, struct fpnode_type *fpnode_data,
	  unsigned line, unsigned rate, int (*free) (void *, void *),
	  void *context)
{
    unsigned i;

    i = line;
    if (rate) {
	rate--;
	for (; i; i--) {
	    if (fpnode_data->node) {
		void *fpnode;

		fpnode = fpnode_data->star;
		back_rate(qsrate_data, fpnode, line, rate, free, context);
		qsrate_data->link_m.free(qsrate_data->link_m.data, fpnode);
	    }

	    fpnode_data++;
	}
    } else {
	unsigned mall;

	mall = qsrate_data->link_a.fplist.mall;

	for (; i; i--) {
	    unsigned node;

	    node = fpnode_data->node;
	    if (node) {
		void *fpnode;

		fpnode = fpnode_data->star;
		back_line(fpnode, node, mall, free, context);
		qsrate_data->link_m.free(qsrate_data->link_m.data, fpnode);
	    }

	    fpnode_data++;
	}
    }

    return -1;
}


static int
back_text(struct qsrate_type *qsrate_data)
{
    qsrate_data->link_m.free
	(qsrate_data->link_m.data, qsrate_data->link_e.fplink_text);

    qsrate_data->link_e.fplink_text = NULL;

    return -1;
}


static int
ever_line(void *data, void *text, unsigned size, unsigned mall,
	  int (*copy) (void *, void *, const void *),
	  int (*free) (void *, void *), void *context)
{
    int status = 0;
    unsigned i;

    i = size;
    for (; i; i--) {
	status = copy(context, data, text);
	if (status) {
	    status = CALL_ERROR;
	    if (1) {
		break;
	    }
	} else {
	    data = (char *) data + mall;
	    text = (char *) text + mall;
	}
    }
    if (i) {
	size -= i;
	back_line((char *) data - size * mall, size, mall, free, context);
    }

    return status;
}


static int
fine_data(struct qsrate_type *qsrate_data, unsigned rate)
{
    int status;

    rate--;
    if (rate) {
	int (*link) (void *, void **, unsigned);
	unsigned size;
	void *data, *node;

	size = sizeof(struct fpnode_type) << qsrate_data->link_a.fplist.lock;

	data = qsrate_data->link_m.data;
	link = qsrate_data->link_m.link;

	do {
	    status = link(data, &node, size);
	    if (status) {
		break;
	    } else {
		struct fplink_type *fplink_data;

		fplink_data = node;
		fplink_data->fplink_data = qsrate_data->link_e.fplink_data;
		qsrate_data->link_e.fplink_data = node;
	    }

	    rate--;
	} while (rate);

	if (rate) {
	    status = LINK_ERROR;
	    if (1) {
		back_data(qsrate_data);
	    }
	}
    } else {
	status = 0;
    }

    return status;
}


static int
fine_text(struct qsrate_type *qsrate_data)
{
    int status;
    void *text;

    status = qsrate_data->link_m.link
	(qsrate_data->link_m.data, &text,
	 qsrate_data->link_a.fplist.line * 3 * qsrate_data->link_a.fplist.mall
	 >> 1);
    if (status) {
	status = LINK_ERROR;
    } else {
	qsrate_data->link_e.fplink_text = text;
    }

    return status;
}


static int
type_line(struct qsrate_type *qsrate_data, struct fpnode_type *fpnode_data,
	  struct fpnode_type *fpnode_text, unsigned line, unsigned rate,
	  int (*copy) (void *, void *, const void *),
	  int (*free) (void *, void *), void *context)
{
    int status = 0;
    unsigned i;

    i = line;
    if (rate) {
	rate--;
	for (; i; i--) {
	    unsigned node;

	    node = fpnode_text->node;

	    fpnode_data->node = node;

	    fpnode_data->call = fpnode_text->call;

	    if (node) {
		void *fpnode;

		status = qsrate_data->link_m.link
		    (qsrate_data->link_m.data, &fpnode,
		     sizeof(struct fpnode_type) * line);
		if (status) {
		    status = LINK_ERROR;
		    if (1) {
			break;
		    }
		} else {
		    status = type_line
			(qsrate_data, fpnode, fpnode_text->star, line, rate,
			 copy, free, context);
		    if (status) {
			qsrate_data->link_m.free
			    (qsrate_data->link_m.data, fpnode);
			if (1) {
			    break;
			}
		    } else {
			fpnode_data->star = fpnode;
		    }
		}
	    }

	    fpnode_data++;
	    fpnode_text++;
	}
	if (i) {
	    for (; i; i--) {
		fpnode_data->node = 0;
		fpnode_data++;
	    }

	    back_rate
		(qsrate_data, fpnode_data - line, line, rate + 1, free,
		 context);
	}
    } else {
	unsigned mall, size;

	mall = qsrate_data->link_a.fplist.mall;

	size = mall * qsrate_data->link_a.fplist.line;

	for (; i; i--) {
	    unsigned node;

	    node = fpnode_text->node;

	    fpnode_data->node = node;

	    fpnode_data->call = fpnode_text->call;

	    if (node) {
		void *fpnode;

		status = qsrate_data->link_m.link
		    (qsrate_data->link_m.data, &fpnode, size);
		if (status) {
		    status = LINK_ERROR;
		    if (1) {
			break;
		    }
		} else {
		    status = ever_line
			(fpnode, fpnode_text->star, node, mall, copy, free,
			 context);
		    if (status) {
			qsrate_data->link_m.free
			    (qsrate_data->link_m.data, fpnode);
			if (1) {
			    break;
			}
		    } else {
			fpnode_data->star = fpnode;
		    }
		}
	    }

	    fpnode_data++;
	    fpnode_text++;
	}
	if (i) {
	    for (; i; i--) {
		fpnode_data->node = 0;
		fpnode_data++;
	    }

	    back_rate(qsrate_data, fpnode_data - line, line, 0, free, context);
	}
    }

    return status;
}


int
_libx1f4l2_here_qsrate(void *qsdata, void *qstext,
		       int (*copy) (void *, void *, const void *),
		       int (*free) (void *, void *), void *context)
{
    int status;
    unsigned rate;

    rate = qsrate(qstext)->link_a.fplist.rate;
    if (rate) {
	status = fine_text(qsdata);
	if (status) {
	} else {
	    status = fine_data(qsdata, rate);
	    if (status) {
	    } else {
		unsigned lock;

		lock = qsrate(qsdata)->link_a.fplist.lock;

		status = qsrate(qsdata)->link_m.mode
		    (qsrate(qsdata)->link_m.data,
		     &qsrate(qsdata)->link_a.fplist.fpnode,
		     sizeof(struct fpnode_type) << lock);
		if (status) {
		    status = MODE_ERROR;
		} else {
		    status = type_line
			(qsdata, qsrate(qsdata)->link_a.fplist.fpnode,
			 qsrate(qstext)->link_a.fplist.fpnode, 1 << lock,
			 rate - 1, copy, free, context);
		    if (status) {
			qsrate(qsdata)->link_m.mode
			    (qsrate(qsdata)->link_m.data,
			     &qsrate(qsdata)->link_a.fplist.fpnode,
			     qsrate(qstext)->link_a.fplist.mall * 3
			     * qsrate(qstext)->link_a.fplist.line >> 1);
		    } else {
			qsrate(qsdata)->link_a.fplist.node =
			    qsrate(qstext)->link_a.fplist.node;
			qsrate(qsdata)->link_a.fplist.rate = rate;
			qsrate(qsdata)->link_a.fplist.size =
			    qsrate(qstext)->link_a.fplist.size;
		    }
		}

		if (status) {
		    back_data(qsdata);
		}
	    }

	    if (status) {
		back_text(qsdata);
	    }
	}
    } else {
	unsigned size;

	size = qsrate(qstext)->link_a.fplist.size;
	if (size) {
#if __MICRO_RATES__
	    unsigned trail;

	    trail = 3 * qsrate(qsdata)->link_a.fplist.line >> 1;
	    while (size << 1 < trail + 1 && ~trail & 1) {
		trail >>= 1;
	    }

	    status = qsrate(qsdata)->link_m.mode
		(qsrate(qsdata)->link_m.data,
		 &qsrate(qsdata)->link_a.fplist.fpnode,
		 qsrate(qsdata)->link_a.fplist.mall * trail);
	    if (status) {
		status = MODE_ERROR;
	    } else {
#endif				/* __MICRO_RATES__ */
		status = ever_line
		    (qsrate(qsdata)->link_a.fplist.fpnode,
		     qsrate(qstext)->link_a.fplist.fpnode, size,
		     qsrate(qstext)->link_a.fplist.mall, copy, free, context);
		if (status) {
		} else {
		    qsrate(qsdata)->link_a.fplist.node =
			qsrate(qstext)->link_a.fplist.node;
		    qsrate(qsdata)->link_a.fplist.size = size;
		}
#if __MICRO_RATES__
	    }
#endif				/* __MICRO_RATES__ */
	} else {
	    status = 0;
	}
    }

    return status;
}
