/*
 * lxxsxx-a.g.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxdata.h>
#include <lxfile.h>
#include <lxlist.h>
#include <lxport-inter.h>
#include <lxport-types.h>
#include <tcvset.h>

#define xsport(port) \
    ((struct xsport_type *) (port))

static int line_s010(struct lxport_type *, struct xsport_type *);
static int line_s030(struct lxport_type *, struct xsport_type *);
static int line_s050(struct lxport_type *, struct xsport_type *);
static int line_s070(struct lxport_type *, struct xsport_type *);

static int
line_s010(struct lxport_type *lxport_data, struct xsport_type *xsport_data)
{
    int status;
    void *text;

    status = x1f4_line_lxfile(lxport_data->link_l.file, &text);
    if (status) {
    } else {
	if (0) {
	    x1f4_flat_lxfile(lxport_data->link_l.file, &text);
	} else {
	    xsport_data->text = text;
	}
    }

    return status;
}


static int
line_s030(struct lxport_type *lxport_data, struct xsport_type *xsport_data)
{
    int status;
    void *path;

    status = x1f4_line_lxdata(lxport_data->link_l.data, &path);
    if (status) {
    } else {
	status = line_s010(lxport_data, xsport_data);
	if (status) {
	    x1f4_flat_lxdata(lxport_data->link_l.data, &path);
	} else {
	    xsport_data->path = path;
	}
    }

    return status;
}


static int
line_s050(struct lxport_type *lxport_data, struct xsport_type *xsport_data)
{
    int status;
    void *line;

    status = x1f4_line_lxfile(lxport_data->link_l.file, &line);
    if (status) {
    } else {
	status = line_s030(lxport_data, xsport_data);
	if (status) {
	    x1f4_flat_lxfile(lxport_data->link_l.file, &line);
	} else {
	    xsport_data->line = line;
	}
    }

    return status;
}


static int
line_s070(struct lxport_type *lxport_data, struct xsport_type *xsport_data)
{
    int status;
    void *argv;

    status = x1f4_post_lxlist
	(lxport_data->link_l.list, &argv, lock_excase(xsport_data));
    if (status) {
    } else {
	status = line_s050(lxport_data, xsport_data);
	if (status) {
	    x1f4_free_lxlist
		(lxport_data->link_l.list, argv, NULL,
		 lock_excase(xsport_data));
	} else {
	    xsport_data->argv = argv;
	}
    }

    return status;
}


int
x1f4_line_xsport(void *subtext, void **address)
{
    int status;
    struct lxport_type *lxport_data;
    void *xsport;

    lxport_data = subtext;

    status = lxport_data->link_m.link
	(lxport_data->link_m.data, &xsport, __struct_xsport_type_alloc_size__);
    if (status) {
	status = _libx1f4i0_lxport_stat_link(lxport_data);
    } else {
	xsport = pick_vxlist(xsport);

	status = line_s070(lxport_data, xsport);
	if (status) {
	    lxport_data->link_m.free
		(lxport_data->link_m.data, lock_cxlist(xsport));
	} else {
	    struct waitlink_type *waitlink_data;

	    lock_excase(xsport)->nodetype_data =
		lxport_data->link_s.nodetype + 1;

	    lock_excase(xsport)->slip = NULL;

	    lock_exlist(xsport)->call = 1;

	    xsport(xsport)->waitlink.port = -1;

	    waitlink_data = lxport_data->link_v.wait;

	    xsport(xsport)->waitlink.waitlink_last = NULL;

	    lxport_data->link_v.wait = &xsport(xsport)->waitlink;

	    xsport(xsport)->waitlink.waitlink_next = waitlink_data;

	    if (waitlink_data) {
		waitlink_data->waitlink_last = &xsport(xsport)->waitlink;
	    }

	    _libx1f4i0_init_tcvset
		(&lock_exlist(xsport)->pset, &lock_exlist(xsport)->text);

	    *address = xsport;
	}
    }

    return status;
}
