/*
 * lxxsxx-a.c.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxlead.h>
#include <lxport-inter.h>
#include <lxport-types.h>
#include <tcvset.h>

#define break_cycles			0

#define lxport(port) \
    ((struct lxport_type *) (port))

int
_libx1f4i0_lxport_side_xsxx(void *subtext, void *xsport)
{
    int status;

    if (!xsport) {
	/*
	 * xsport may well be null... - test may not be removed.
	 */

	status = 0;
    } else {
	unsigned call;

	call = lock_exlist(xsport)->call;
	if (call ^ 1) {
	    int (*miss) (void *, struct x1f4_nodelink_type **,
			 struct x1f4_nodelink_type *);

	    lock_exlist(xsport)->call = call - 1;

	    miss = lxport(subtext)->link_r.miss;
	    if (miss) {
		status = miss
		    (lxport(subtext)->link_r.text, NULL,
		     lock_excase(xsport));
	    } else {
		status = x1f4_mind_lxlead(NULL, xsport);
	    }
	} else {
	    int excess;

	    lock_exlist(xsport)->call = break_cycles;

	    status = _libx1f4i0_lxport_null_xsxx(subtext, NULL, xsport);

	    excess = _libx1f4i0_lxport_fine_xsxx(subtext, xsport);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}
    }

    return status;
}
