/*
 * lxtrap-types.h
 * Copyright (C) 2008, 2009, 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxtrap_types_H__
#define __LIBx1f4_lxtrap_types_H__

#include <config.h>

#include <e4.h>

/*
 * NOTES
 *
 *.some error recorder in addition to the error dumper is in good order.  such
 * recorder would record the error type (this library identification -
 * application side, since such identification is created by the application)
 * and the error details (library error type and details)
 */
typedef struct lxtrap_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	const struct x1f4_eelookup_type *eelookup_data;
    } trap_e;
    struct {
	void *data, *rail;
    } link_f;
    struct {
	int type;
    } link_g;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
    struct {
	int (*link) (void *, int, int, const struct x1f4_operator_type **);
	void *text;
    } link_p;
    struct {
	int (*link) (void *, int, int, const struct x1f4_linetext_type **);
	void *text;
    } link_q;
    struct {
	unsigned miss;
	const void *data;
    } link_t;
    struct {
	int (*link) (void *, void **, unsigned);
	void *data;
    } link_v;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} lxtrap_type;

typedef struct lxtype_type {
    int (*lead) (void *, void **), (*slip) (void *, void **), type;
    void *text;
} lxtype_type;

typedef struct missed_type {
    union {
	X1f4_E4_C_BILL bill;
	X1f4_E4_C_MODE mode;
	X1f4_E4_C_REAL real;
	X1f4_E4_C_TEXT text;
	X1f4_E4_C_USER user;
    } data;
} missed_type;

typedef struct screen_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	const struct x1f4_eelookup_type *eelookup_data;
    } trap_e;
    struct {
	int type;
    } link_g;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
    struct {
	void *fine;
    } link_o;
    struct {
	int (*link) (void *, int, int, const struct x1f4_operator_type **);
	void *text;
    } link_p;
    struct {
	int (*link) (void *, int, int, const struct x1f4_linetext_type **);
	void *text;
    } link_q;
    struct {
	unsigned miss;
	const void *data;
    } link_t;
    struct {
	int (*link) (void *, void **, unsigned);
	void *data;
    } link_v;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} screen_type;

#endif				/* __LIBx1f4_lxtrap_types_H__ */
