/*
 * lxtrap-l.w.1.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <copy.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcast.h>
#include <lxtrap-inter.h>
#include <lxtrap-types.h>
#include <retain.h>

#if __RETAIN_OBJECT_DATA__
# error data for created objects is not retained, as probably should have been
#endif				/* __RETAIN_OBJECT_DATA__ */

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

typedef struct miss_type {
    int land, type;
    void *lxtrap, *missed, *report;
} miss_type;

extern const void *const x1f4_a1_walk_link;

static int lock_port(int, void *, void *, int, struct lxtrap_type *);
static int miss_call(void *, int, void *, struct x1f4_dispatch_type **);
static int pick_call(void *, void *, int, void *, void **, void **, void **,
		     struct lxtrap_type *, struct x1f4_linetext_type *);
static int slip_call(void *, void *, int, void *, void **, void **, void **,
		     struct lxtrap_type *, struct x1f4_linetext_type *);

static int
lock_port(int land, void *report, void *missed, int type,
	  struct lxtrap_type *lxtrap_data)
{
    int status = 0;
    const struct lxtype_type *lxtype_data;
    unsigned i;

    lxtype_data = lxtrap_data->link_t.data;

    i = lxtrap_data->link_t.miss;
    for (; i; i--) {
	if (lxtype_data->type == land) {
	    break;
	} else {
	    lxtype_data++;
	}
    }

    do {
	if (type == lxtrap_data->link_g.type) {
	    struct x1f4_dxcast_type *dxcast_data;

	    dxcast_data = I_USER(missed);
	    type = dxcast_data->type;
	    if (land != type) {
		status = _libx1f4i0_lxtrap_stat_miss(lxtrap_data, land, type);
		if (1) {
		    break;
		}
	    } else {
		missed = &dxcast_data->data;
	    }
	}

	if (i) {
	    if (lxtype_data->slip) {
		if (lxtype_data->lead) {
		    void *context;

		    context = lxtype_data->text;
		    status = lxtype_data->lead(context, missed);
		    if (status) {
			break;
		    } else {
			status = lxtype_data->slip(context, report);
			if (status) {
			    lxtype_data->slip(context, missed);
			    if (1) {
				break;
			    }
			}
		    }
		}
	    }
	}

	copy_miss(report, land, missed);
    } while (0);

    return status;
}


static int
miss_call(void *text, int status, void *output,
	  struct x1f4_dispatch_type **dispatch)
{
    if (status) {
    } else {
	struct miss_type *miss_data;

	miss_data = text;
	status = lock_port
	    (miss_data->land, miss_data->report, miss_data + 1,
	     miss_data->type, miss_data->lxtrap);
    }
    if (status == X1f4_EX_CAN_CONTINUE) {
	status = 0;
	l_MODE(-1, output);
    } else {
	l_MODE(status, output);
    }

    *dispatch = NULL;

    return status;
}


static int
pick_call(void *context, void *output, int land, void *report, void **input,
	  void **track, void **side, struct lxtrap_type *lxtrap_data,
	  struct x1f4_linetext_type *linetext_data)
{
    int status;

    do {
	struct missed_type missed;
	void *deftext;

	deftext = (void *) linetext_data->context;

	if (linetext_data->function.flags
	    & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
	    status = _libx1f4i0_lxtrap_pick_call
		(context, side, 2, lxtrap_data, &linetext_data, &deftext);
	    if (status) {
		break;
	    }
	}

	status = linetext_data->function.function(deftext, &missed, track);
	if (status) {
	} else {
	    status = lock_port
		(land, report, &missed, linetext_data->function.type,
		 lxtrap_data);
	}
	if (status) {
	    if (status == X1f4_EX_CAN_CONTINUE) {
		status = 0;
		l_MODE(-1, output);
	    } else {
	    }
	} else {
	    l_MODE(0, output);
	}
    } while (0);

    return status;
}


static int
slip_call(void *context, void *output, int land, void *report, void **input,
	  void **track, void **side, struct lxtrap_type *lxtrap_data,
	  struct x1f4_linetext_type *linetext_data)
{
    int status;

    do {
	int type;
	unsigned mind;
	void *miss;

	type = linetext_data->function.type;

	if (linetext_data->function.flags
	    & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
	    mind = sizeof(struct x1f4_linetext_type);
	    if (linetext_data->function.flags
		& (X1f4_E4_LINK_PASS | X1f4_E4_POST_TYPE)) {
		mind += (((struct x1f4_function_type *) side[1])->count - 2)
		    * sizeof(int) << 1;
	    } else {
		if (linetext_data->function.count) {
		    mind += sizeof(int)
			* (((struct x1f4_function_type *) side[1])->count - 2);
		}
	    }
	} else {
	    mind = 0;
	}

	status = lxtrap_data->link_v.link
	    (lxtrap_data->link_v.data, &miss,
	     sizeof(struct x1f4_dispatch_type) + sizeof(struct miss_type)
	     + sizeof(struct missed_type) + mind);
	if (status) {
	    status = _libx1f4i0_lxtrap_stat_link(lxtrap_data);
	    break;
	} else {
	    struct miss_type *miss_data;
	    struct x1f4_dispatch_type *dispatch_data;
	    void *subtext;

	    dispatch_data = miss;

	    miss_data = (void *) (dispatch_data + 1);

	    output = input[0];

	    subtext = (void *) linetext_data->context;

	    if (mind) {
		status = _libx1f4i0_lxtrap_slip_call
		    (context, side, 2, lxtrap_data, &linetext_data,
		     (void *) ((struct missed_type *) (miss_data + 1) + 1),
		     &subtext);
		if (status) {
		    break;
		}
	    }

	    miss_data->type = linetext_data->function.type;
	    miss_data->land = land;
	    miss_data->report = report;

	    miss_data->lxtrap = lxtrap_data;

	    dispatch_data->back = miss_data;
	    dispatch_data->call = miss_call;

	    dispatch_data->transfer.context = subtext;
	    dispatch_data->transfer.function_data = &linetext_data->function;
	    dispatch_data->transfer.input = track;
	    dispatch_data->transfer.output = miss_data + 1;

	    input[2] = dispatch_data;
	}
    } while (0);

    return status;
}


int
_libx1f4i0_lxtrap_w1logique(void *context, void *output, void **input)
{
    int linked, status;
    struct lxtrap_type *lxtrap_data;
    struct x1f4_dxcast_type *dxcast_data;
    void **side, **track;

    linked = output == x1f4_a1_walk_link;

    side = context;

    lxtrap_data = side[0];

    if (linked) {
	track = input[1];
    } else {
	track = input;
    }

    dxcast_data = I_USER(track[1]);

    if (X1f4_E4_CALL < dxcast_data->type) {
	int object_type, type, wind;
	struct x1f4_linetext_type *linetext_data;

	linetext_data = I_USER(&dxcast_data->data);

	wind = linetext_data->function.type;

	object_type = lxtrap_data->link_g.type;

	type = *((struct x1f4_function_type *) side[1])->args;
	if (wind == type || wind == object_type) {
	    if (type ^ object_type) {
		void *missed;

		missed = *track;

		track += 2;

		status = _libx1f4i0_lxtrap_even_list
		    (&linetext_data->function, side[1], 2, &track,
		     lxtrap_data);
		if (status) {
		} else {
		    if (linetext_data->function.function) {
			int (*call) (void *, void *, int, void *, void **,
				     void **, void **, struct lxtrap_type *,
				     struct x1f4_linetext_type *);

			if (linked) {
			    call = slip_call;
			} else {
			    call = pick_call;
			}

			status = call
			    (context, output, type, missed, input, track, side,
			     lxtrap_data, linetext_data);
		    } else {
			status = _libx1f4i0_lxtrap_stat_null
			    (lxtrap_data, "wrap", 4);
		    }
		}
	    } else {
		status = _libx1f4i0_lxtrap_stat_cast(lxtrap_data);
	    }
	} else {
	    status = _libx1f4i0_lxtrap_stat_post
		(lxtrap_data, type, linetext_data->function.type);
	}
    } else {
	status = _libx1f4i0_lxtrap_stat_call(lxtrap_data, 0, "wrap", 4);
    }

    return status;
}
