/*
 * lxtrap-l.c.1.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxcast.h>
#include <lxtrap-inter.h>
#include <lxtrap-types.h>
#include <retain.h>

#if __RETAIN_OBJECT_DATA__
# error data for created objects is not retained, as probably should have been
#endif				/* __RETAIN_OBJECT_DATA__ */

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

extern const void *const x1f4_a1_walk_link;

static int miss_call(void *, int, void *, struct x1f4_dispatch_type **);
static int pick_call(void *, void *, void **, void **, void **,
		     struct lxtrap_type *, struct x1f4_linetext_type *);
static int slip_call(void *, void *, void **, void **, void **,
		     struct lxtrap_type *, struct x1f4_linetext_type *);

static int
miss_call(void *text, int success, void *output,
	  struct x1f4_dispatch_type **dispatch)
{
    *dispatch = NULL;

    return success;
}


static int
pick_call(void *context, void *output, void **input, void **track, void **side,
	  struct lxtrap_type *lxtrap_data,
	  struct x1f4_linetext_type *linetext_data)
{
    int status;

    do {
	int type;
	void *deftext;

	deftext = (void *) linetext_data->context;

	if (linetext_data->function.flags
	    & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
	    status = _libx1f4i0_lxtrap_pick_call
		(context, side, 1, lxtrap_data, &linetext_data, &deftext);
	    if (status) {
		break;
	    }
	}

	type = linetext_data->function.type;

	if (type == lxtrap_data->link_g.type) {
	} else {
	    void *miss;

	    status = lxtrap_data->link_v.link
		(lxtrap_data->link_v.data, &miss,
		 sizeof(struct x1f4_dxcast_type));
	    if (status) {
		status = _libx1f4i0_lxtrap_stat_link(lxtrap_data);
		break;
	    } else {
		struct x1f4_dxcast_type *dxcast_data;

		dxcast_data = miss;

		l_USER(miss, output);

		dxcast_data->call = 0;
		dxcast_data->type = type;

		output = &dxcast_data->data;
	    }
	}

	status = linetext_data->function.function(deftext, output, track);
    } while (0);

    return status;
}


static int
slip_call(void *context, void *output, void **input, void **track, void **side,
	  struct lxtrap_type *lxtrap_data,
	  struct x1f4_linetext_type *linetext_data)
{
    int status;

    do {
	int type;
	unsigned cast, mind;
	void *miss;

	type = linetext_data->function.type;

	if (type == lxtrap_data->link_g.type) {
	    cast = 0;
	} else {
	    cast = sizeof(struct x1f4_dxcast_type);
	}

	if (linetext_data->function.flags
	    & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
	    mind = sizeof(struct x1f4_linetext_type);
	    if (linetext_data->function.flags
		& (X1f4_E4_LINK_PASS | X1f4_E4_POST_TYPE)) {
		mind += (((struct x1f4_function_type *) side[1])->count - 1)
		    * sizeof(int) << 1;
	    } else {
		if (linetext_data->function.count) {
		    mind += sizeof(int)
			* (((struct x1f4_function_type *) side[1])->count - 1);
		}
	    }
	} else {
	    mind = 0;
	}

	status = lxtrap_data->link_v.link
	    (lxtrap_data->link_v.data, &miss,
	     sizeof(struct x1f4_dispatch_type) + cast + mind);
	if (status) {
	    status = _libx1f4i0_lxtrap_stat_link(lxtrap_data);
	    break;
	} else {
	    struct x1f4_dispatch_type *dispatch_data;
	    void *subtext;

	    dispatch_data = miss;

	    output = input[0];

	    if (cast) {
		struct x1f4_dxcast_type *dxcast_data;

		dxcast_data = (void *) (dispatch_data + 1);

		l_USER(dxcast_data, output);

		dxcast_data->call = 0;
		dxcast_data->type = type;

		output = &dxcast_data->data;
	    }

	    subtext = (void *) linetext_data->context;

	    if (mind) {
		status = _libx1f4i0_lxtrap_slip_call
		    (context, side, 1, lxtrap_data, &linetext_data,
		     (void *) ((char *) (dispatch_data + 1) + cast), &subtext);
		if (status) {
		    break;
		}
	    }

	    dispatch_data->back = NULL;
	    dispatch_data->call = miss_call;

	    dispatch_data->transfer.context = subtext;
	    dispatch_data->transfer.function_data = &linetext_data->function;
	    dispatch_data->transfer.input = track;
	    dispatch_data->transfer.output = output;

	    input[2] = dispatch_data;
	}
    } while (0);

    return status;
}


int
_libx1f4i0_lxtrap_c1logique(void *context, void *output, void **input)
{
    int linked, status;
    struct lxtrap_type *lxtrap_data;
    struct x1f4_dxcast_type *dxcast_data;
    void **side, **track;

    linked = output == x1f4_a1_walk_link;

    side = context;

    lxtrap_data = side[0];

    if (linked) {
	track = input[1];
    } else {
	track = input;
    }

    dxcast_data = I_USER(track[0]);

    if (X1f4_E4_CALL < dxcast_data->type) {
	struct x1f4_linetext_type *linetext_data;

	linetext_data = I_USER(&dxcast_data->data);

	track++;

	status = _libx1f4i0_lxtrap_even_list
	    (&linetext_data->function, side[1], 1, &track, lxtrap_data);
	if (status) {
	} else {
	    if (linetext_data->function.function) {
		int (*call) (void *, void *, void **, void **, void **,
			     struct lxtrap_type *,
			     struct x1f4_linetext_type *);

		if (linked) {
		    call = slip_call;
		} else {
		    call = pick_call;
		}

		status = call
		    (context, output, input, track, side, lxtrap_data,
		     linetext_data);
	    } else {
		status = _libx1f4i0_lxtrap_stat_null(lxtrap_data, "call", 4);
	    }
	}
    } else {
	status = _libx1f4i0_lxtrap_stat_call(lxtrap_data, 0, "call", 4);
    }

    return status;
}
