/*
 * lxtrap-e.7.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <lxtrap-inter.h>
#include <lxtrap-types.h>
#include <trans.h>

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxtrap_slip_text(void *subtext, void **address)
{
    int status;
    void *text;

    text = *address;

    if (text == x1f4_c1_empty_string) {
	status = 0;
    } else {
	struct lxtrap_type *lxtrap_data;

	lxtrap_data = subtext;

	status = lxtrap_data->link_m.free(lxtrap_data->link_m.data, text);
	if (status) {
	    status = _libx1f4i0_lxtrap_stat_free(lxtrap_data);
	} else {
	}
    }

    return status;
}
