/*
 * lxtrap-a.j.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <copy.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcast.h>
#include <lxtrap-inter.h>
#include <lxtrap-types.h>

#define I_BILL(t)			(*((X1f4_E4_C_BILL *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_REAL(t)			(*((X1f4_E4_C_REAL *) (t)))

#define l_BILL(e, output) \
    {									      \
	X1f4_E4_C_BILL *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define l_REAL(e, output) \
    {									      \
	X1f4_E4_C_REAL *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define SCALAR_BITS \
    ((1 << X1f4_E4_BILL) | (1 << X1f4_E4_MODE) | (1 << X1f4_E4_REAL))

static int rule_line(const struct x1f4_function_type *, unsigned,
		     unsigned, const struct x1f4_function_type *, unsigned,
		     unsigned, unsigned, struct lxtrap_type *,
		     struct missed_type *, void **);
static int type_name(int, int, void *, void *);

static int
rule_line(const struct x1f4_function_type *function_text,
	  unsigned o, unsigned post,
	  const struct x1f4_function_type *function_data, unsigned offset,
	  unsigned h, unsigned mind, struct lxtrap_type *lxtrap_data,
	  struct missed_type *missed_data, void **track)
{
    const int *data;
    int delete, status = 0;
    const int *text;

    data = function_data->args + offset;
    text = function_text->args;

    h += offset;

    delete = o;
    for (; delete; delete--, track++) {
	int name, type;

	name = *data;
	type = *text;
	if (type == X1f4_E4_SLIP) {
	    type = name;
	}

	if (name ^ type) {
	    do {
		if ((type | name) & ~15) {
		} else {
		    if ((1 << type) & SCALAR_BITS
			&& (1 << name) & SCALAR_BITS) {
			type_name(type, name, *track, missed_data);
			*track = missed_data;
			missed_data++;
			break;
		    }
		}

		if (name == lxtrap_data->link_g.type) {
		    int fold;
		    struct x1f4_dxcast_type *dxcast_data;

		    dxcast_data = *(void **) *track;
		    fold = dxcast_data->type;
		    if (fold ^ type) {
			if ((type | fold) & ~15) {
			} else {
			    if ((1 << type) & SCALAR_BITS
				&& (1 << fold) & SCALAR_BITS) {
				type_name(type, fold, &dxcast_data->data,
					  missed_data);
				*track = missed_data;
				missed_data++;
				break;
			    }
			}
		    } else {
			copy_miss(missed_data, name, &dxcast_data->data);
			*track = missed_data;
			missed_data++;
			break;
		    }
		}

		if (lxtrap_data->link_p.link) {
		    const struct x1f4_operator_type *operator_data;

		    status = lxtrap_data->link_p.link
			(lxtrap_data->link_p.text, type, name, &operator_data);
		    if (status) {
		    } else {
			status = operator_data->operator(missed_data, track);
			if (status) {
			    break;
			} else {
			    *track = missed_data;
			    missed_data++;
			    break;
			}
		    }
		}

		if (lxtrap_data->link_q.link) {
		    const struct x1f4_linetext_type *linetext_data;

		    status = lxtrap_data->link_q.link
			(lxtrap_data->link_q.text, type, name, &linetext_data);
		    if (status) {
		    } else {
			status = linetext_data->function.function
			    ((void *) linetext_data->context, missed_data,
			     track);
			if (status) {
			    break;
			} else {
			    *track = missed_data;
			    missed_data++;
			    break;
			}
		    }
		}

		status = X1f4_EX_CANNOT_CONTINUE;
	    } while (0);
	    if (status) {
		break;
	    }
	} else {
	    if (post) {
		if (mind) {
		    unsigned pass;

		    pass = text[o];
		    if ((data[h] ^ pass) & X1f4_E4_POST_XSET) {
			if (pass & X1f4_E4_POST_XSET) {
			} else {
			    copy_miss(missed_data, name, *track);
			    *track = missed_data;
			    missed_data++;
			}
		    }
		}
	    } else {
		if (mind) {
		    if (data[h] & X1f4_E4_POST_XSET) {
			copy_miss(missed_data, name, *track);
			*track = missed_data;
			missed_data++;
		    }
		}
	    }
	}

	data++;
	text++;
    }
    if (delete) {
    } else {
	if (function_text->flags & X1f4_E4_LINK_PASS) {
	} else {
	    delete = h - o - offset;
	    for (; delete; delete--, track++) {
		if (mind) {
		    if (data[h] & X1f4_E4_POST_XSET) {
			copy_miss(missed_data, *data, *track);
			*track = missed_data;
			missed_data++;
		    }
		}
	    }

	    data++;
	}
    }

    return status;
}


static int
type_name(int type, int name, void *lead, void *seek)
{
    switch (type) {
    case X1f4_E4_BILL:
	if (name == X1f4_E4_MODE) {
	    l_BILL(I_MODE(lead), seek);
	} else {
	    l_BILL(I_REAL(lead), seek);
	}
	break;
    case X1f4_E4_MODE:
	if (name == X1f4_E4_BILL) {
	    l_MODE(I_BILL(lead), seek);
	} else {
	    l_MODE(I_REAL(lead), seek);
	}
	break;
    default:
	if (name == X1f4_E4_BILL) {
	    l_REAL(I_BILL(lead), seek);
	} else {
	    l_REAL(I_MODE(lead), seek);
	}
    }

    return 0;
}


int
_libx1f4i0_lxtrap_even_list(const struct x1f4_function_type *function_text,
			    const struct x1f4_function_type *function_data,
			    unsigned offset,
			    void ***input, struct lxtrap_type *lxtrap_data)
{
    int delete, status = 0;
    unsigned h, o;

    h = function_data->count;
    o = function_text->count;

    delete = h - o - offset;
    if (delete && !(0 < delete && function_text->flags & X1f4_E4_SIDE_LIST)) {
	status = _libx1f4i0_lxtrap_stat_list(lxtrap_data, h - offset, o);
    } else {
	unsigned flat = 0, mind, post;
	const int *data, *text;

	data = function_data->args + offset;
	text = function_text->args;

	mind = function_data->flags & X1f4_E4_POST_TYPE;
	post = function_text->flags & X1f4_E4_POST_TYPE;

	delete = o;
	for (; delete; delete--) {
	    int name, type;

	    name = *data;
	    type = *text;
	    if (type == X1f4_E4_SLIP) {
		type = name;
	    }

	    if (name ^ type) {
		do {
		    if ((type | name) & ~15) {
		    } else {
			if ((1 << type) & SCALAR_BITS
			    && (1 << name) & SCALAR_BITS) {
			    type = name;
			    flat++;
			    break;
			}
		    }

		    if (lxtrap_data->link_p.link) {
			const struct x1f4_operator_type *operator_data;

			if (lxtrap_data->link_p.link
			    (lxtrap_data->link_p.text, type, name,
			     &operator_data)) {
			} else {
			    type = name;
			    flat++;
			    break;
			}
		    }

		    if (lxtrap_data->link_q.link) {
			const struct x1f4_linetext_type *linetext_data;

			if (lxtrap_data->link_q.link
			    (lxtrap_data->link_q.text, type, name,
			     &linetext_data)) {
			} else {
			    type = name;
			    flat++;
			    break;
			}
		    }

		    status = _libx1f4i0_lxtrap_stat_lock
			(lxtrap_data, name, type, text - function_text->args);
		} while (0);
		if (name ^ type) {
		    if (1) {
			break;
		    }
		}

		if (post) {
		    if (text[o] & X1f4_E4_POST_XSET) {
			/*
			 * can convert the types, but not the reference...
			 * display a better descriptive message?
			 */
			status = _libx1f4i0_lxtrap_stat_fink
			    (lxtrap_data, text - function_text->args);
			if (1) {
			    break;
			}
		    }
		}
	    } else {
		if (post) {
		    if (mind) {
			unsigned pass;

			pass = text[o];
			if ((data[h] ^ pass) & X1f4_E4_POST_XSET) {
			    if (pass & X1f4_E4_POST_XSET) {
				status = _libx1f4i0_lxtrap_stat_fink
				    (lxtrap_data, text - function_text->args);
				if (1) {
				    break;
				}
			    } else {
				flat++;
			    }
			}
		    } else {
			if (text[o] & X1f4_E4_POST_XSET) {
			    status = _libx1f4i0_lxtrap_stat_fink
				(lxtrap_data, text - function_text->args);
			    if (1) {
				break;
			    }
			}
		    }
		} else {
		    if (mind) {
			if (data[h] & X1f4_E4_POST_XSET) {
			    flat++;
			}
		    }
		}
	    }

	    data++;
	    text++;
	}
	if (delete) {
	} else {
	    if (function_text->flags & X1f4_E4_LINK_PASS) {
	    } else {
		delete = h - o - offset;
		for (; delete; delete--) {
		    if (mind) {
			if (data[h] & X1f4_E4_POST_XSET) {
			    flat++;
			}
		    }
		}

		data++;
	    }

	    if (flat) {
		void *line;

		h -= offset;

		status = lxtrap_data->link_v.link
		    (lxtrap_data->link_v.data, &line,
		     sizeof(void *) * h + flat * sizeof(struct missed_type));
		if (status) {
		    status = _libx1f4i0_lxtrap_stat_link(lxtrap_data);
		} else {
		    struct missed_type *missed_data;
		    void **track;

		    memcpy(line, *input, sizeof(void *) * h);

		    *input = line;

		    track = line;

		    missed_data = (void *) ((void **) line + h);

		    status = rule_line
			(function_text, o, post, function_data,
			 offset, h, mind, lxtrap_data, missed_data, track);
		}
	    }
	}
    }

    return status;
}
