/*
 * lxtrap-a.i.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <lxtrap-inter.h>
#include <lxtrap-types.h>

int
_libx1f4i0_lxtrap_pick_call(void *context, void **side, unsigned offset,
			    struct lxtrap_type *lxtrap_data,
			    struct x1f4_linetext_type **linetext,
			    void **subtext)
{
    int status;
    struct x1f4_function_type *function_data;
    struct x1f4_linetext_type *linetext_data;
    unsigned count, flags, white = 0;
    void *miss;

    function_data = side[1];

    linetext_data = *linetext;

    count = function_data->count - offset;

    flags = linetext_data->function.flags;

    if (flags & (X1f4_E4_LINK_PASS | X1f4_E4_POST_TYPE)) {
	flags |= X1f4_E4_POST_TYPE;
	white += count * sizeof(int) << 1;
    } else {
	if (linetext_data->function.count) {
	    white += count * sizeof(int);
	}
    }

    status = lxtrap_data->link_v.link
	(lxtrap_data->link_v.data, &miss,
	 sizeof(struct x1f4_linetext_type) + white);
    if (status) {
	status = _libx1f4i0_lxtrap_stat_link(lxtrap_data);
    } else {
	int *args;
	struct x1f4_linetext_type *linetext_slip;

	linetext_slip = miss;

	*linetext_slip = *linetext_data;

	if (white) {
	    int *line;
	    const int *plot, *text;
	    unsigned class, i, scale;

	    args = (void *) (linetext_slip + 1);
	    line = args;
	    plot = linetext_slip->function.args;
	    class = linetext_slip->function.count;
	    scale = count - class;
	    text = function_data->args + offset + class;
	    i = class;
	    for (; i; i--) {
		int slip;

		slip = *plot++;
		*line++ = slip == X1f4_E4_SLIP ? *(text - i) : slip;
	    }
	    memcpy(line, text, scale * sizeof(int));
	    if (flags & X1f4_E4_POST_TYPE) {
		line += scale;
		memcpy(line, plot, class * sizeof(int));
		line += class;
		memcpy(line, text + count + offset, scale * sizeof(int));
	    }
	} else {
	    args = (void *) (function_data->args + offset);
	}

	linetext_slip->function.args = args;
	linetext_slip->function.count = count;
	linetext_slip->function.flags =
	    flags & ~(X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST);

	status = linetext_data->function.function(*subtext, miss, &miss);
	if (status) {
	} else {
	    *linetext = linetext_slip;

	    linetext_slip->context = miss;

	    if (linetext_slip->function.flags & X1f4_E4_TEXT_LINK) {
		*subtext = (void *) linetext_slip->context;
	    } else {
	    }
	}
    }

    return status;
}
