/*
 * lxtrap-a.e.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <exerrors.h>
#if !defined HAVE_LIBx1f4i0
# include <integral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxtrap-types.h>
#if !defined HAVE_LIBx1f4i0
# include <ordinal.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define lxtrap(lxtrap) \
    ((struct lxtrap_type *) (lxtrap))

static int make_rank(void *, int (*) (void *, const char *, unsigned), int);

static int
make_rank(void *data, int (*push) (void *, const char *, unsigned), int rank)
{
    int status;

    status = x1f4_vprint_dintegral(data, push, rank + 1);
    if (status) {
    } else {
	char miss[2];

	x1f4_extend_ordinal(miss, rank);
	status = push(data, miss, 2);
    }

    return status;
}


int
_libx1f4i0_lxtrap_stat_call(void *lxtrap, int rank, const char *call,
			    unsigned size)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtrap(lxtrap)->link_e.data;

	line = lxtrap(lxtrap)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtrap(lxtrap)->link_e.push;
	if (push) {
	    status = push(data, "non function pointer ", 21);
	    if (status) {
		break;
	    } else {
		status = make_rank(data, push, rank);
		if (status) {
		    break;
		} else {
		    status = push(data, " argument for function `", 24);
		    if (status) {
			break;
		    } else {
			status = push(data, call, size);
			if (status) {
			    break;
			} else {
			    status = push(data, "'", 1);
			    if (status) {
				break;
			    }
			}
		    }
		}
	    }
	}

	post = lxtrap(lxtrap)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtrap_stat_cast(void *lxtrap)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtrap(lxtrap)->link_e.data;

	line = lxtrap(lxtrap)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtrap(lxtrap)->link_e.push;
	if (push) {
	    status = push(data, "will not set data of the `object' type", 38);
	    if (status) {
		break;
	    }
	}

	post = lxtrap(lxtrap)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxtrap_stat_fink(void *lxtrap, int rank)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtrap(lxtrap)->link_e.data;

	line = lxtrap(lxtrap)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtrap(lxtrap)->link_e.push;
	if (push) {
	    status = push(data, "unmatched reference class for the ", 34);
	    if (status) {
		break;
	    } else {
		status = make_rank(data, push, rank);
		if (status) {
		    break;
		} else {
		    status = push(data, " argument", 9);
		    if (status) {
			break;
		    }
		}
	    }
	}

	post = lxtrap(lxtrap)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtrap_stat_free(void *lxtrap)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtrap(lxtrap)->link_e.data;

	line = lxtrap(lxtrap)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtrap(lxtrap)->link_e.push;
	if (push) {
	    status = push(data, "cannot free memory", 18);
	    if (status) {
		break;
	    }
	}

	post = lxtrap(lxtrap)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxtrap_stat_link(void *lxtrap)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtrap(lxtrap)->link_e.data;

	line = lxtrap(lxtrap)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtrap(lxtrap)->link_e.push;
	if (push) {
	    status = push(data, "cannot allocate memory", 22);
	    if (status) {
		break;
	    }
	}

	post = lxtrap(lxtrap)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxtrap_stat_list(void *lxtrap, unsigned found, unsigned expected)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtrap(lxtrap)->link_e.data;

	line = lxtrap(lxtrap)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtrap(lxtrap)->link_e.push;
	if (push) {
	    status = push(data, "wrong number of arguments (", 27);
	    if (status) {
		break;
	    } else {
		status = x1f4_vprint_dcardinal(data, push, found);
		if (status) {
		    break;
		} else {
		    status = push(data, " found, ", 8);
		    if (status) {
			break;
		    } else {
			status = x1f4_vprint_dcardinal(data, push, expected);
			if (status) {
			    break;
			} else {
			    status = push
				(data, " expected) for called function", 30);
			    if (status) {
				break;
			    }
			}
		    }
		}
	    }
	}

	post = lxtrap(lxtrap)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtrap_stat_lock(void *lxtrap, int found, int expected, int rank)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtrap(lxtrap)->link_e.data;

	line = lxtrap(lxtrap)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtrap(lxtrap)->link_e.push;
	if (push) {
	    status = push(data, "mismatched type (", 17);
	    if (status) {
		break;
	    } else {
		status = x1f4_dump_type
		    (data, push, found, lxtrap(lxtrap)->trap_e.eelookup_data);
		if (status) {
		    break;
		} else {
		    status = push(data, " found, ", 8);
		    if (status) {
			break;
		    } else {
			status = x1f4_dump_type
			    (data, push, expected,
			     lxtrap(lxtrap)->trap_e.eelookup_data);
			if (status) {
			    break;
			} else {
			    status = push
				(data, " expected) for the called function ",
				 35);
			    if (status) {
				break;
			    } else {
				status = make_rank(data, push, rank);
				if (status) {
				    break;
				} else {
				    status = push(data, " argument", 9);
				    if (status) {
					break;
				    }
				}
			    }
			}
		    }
		}
	    }
	}

	post = lxtrap(lxtrap)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtrap_stat_miss(void *lxtrap, int first, int second)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtrap(lxtrap)->link_e.data;

	line = lxtrap(lxtrap)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtrap(lxtrap)->link_e.push;
	if (push) {
	    status = push(data, "unmatched output types (store is ", 33);
	    if (status) {
		break;
	    } else {
		status = x1f4_dump_type
		    (data, push, first, lxtrap(lxtrap)->trap_e.eelookup_data);
		if (status) {
		    break;
		} else {
		    status = push(data, ", result is ", 12);
		    if (status) {
			break;
		    } else {
			status = x1f4_dump_type
			    (data, push, second,
			     lxtrap(lxtrap)->trap_e.eelookup_data);
			if (status) {
			    break;
			} else {
			    status = push(data, ")", 1);
			    if (status) {
				break;
			    }
			}
		    }
		}
	    }
	}

	post = lxtrap(lxtrap)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtrap_stat_null(void *lxtrap, const char *call, unsigned size)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtrap(lxtrap)->link_e.data;

	line = lxtrap(lxtrap)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtrap(lxtrap)->link_e.push;
	if (push) {
	    status = push(data, call, size);
	    if (status) {
		break;
	    } else {
		status = push(data, ": null function pointer", 23);
		if (status) {
		    break;
		}
	    }
	}

	post = lxtrap(lxtrap)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtrap_stat_post(void *lxtrap, int first, int second)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtrap(lxtrap)->link_e.data;

	line = lxtrap(lxtrap)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtrap(lxtrap)->link_e.push;
	if (push) {
	    status = push(data, "unmatched output types (store is ", 33);
	    if (status) {
		break;
	    } else {
		status = x1f4_dump_type
		    (data, push, first, lxtrap(lxtrap)->trap_e.eelookup_data);
		if (status) {
		    break;
		} else {
		    status = push(data, ", function is ", 14);
		    if (status) {
			break;
		    } else {
			status = x1f4_dump_type
			    (data, push, second,
			     lxtrap(lxtrap)->trap_e.eelookup_data);
			if (status) {
			    break;
			} else {
			    status = push(data, ")", 1);
			    if (status) {
				break;
			    }
			}
		    }
		}
	    }
	}

	post = lxtrap(lxtrap)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
