/*
 * lxtrap-a.a.c
 * Copyright (C) 2011-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxcall.h>
#include <lxtrap-types.h>
#include <variable.h>

int
x1f4_vset_lxtrap(void *lxtrap, void **context)
{
    int status;
    const struct qssc_type *qssc_data;

    qssc_data = ((struct lxtrap_type *) lxtrap)->link_f.rail;

    do {
	status = x1f4_push_variable
	    (context, qssc_data->variable.name,
	     qssc_data->variable.length, qssc_data->variable.type,
	     qssc_data->variable.flags, (void *) &qssc_data->data);
	if (status) {
	    break;
	}

	qssc_data++;
    } while (qssc_data->variable.name);

    return status;
}
