/*
 * lxtrap-a.0.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-m.0.h>
#include <e4.h>
#include <e4fine.h>
#include <lxcall.h>
#include <lxtrap-defs.h>
#include <lxtrap-inter.h>
#include <lxtrap-types.h>
#include <nt.h>

#define screen(screen) \
    ((struct screen_type *) (screen))

extern const struct x1f4_eelookup_type _x1f4_type_lookup;

static int init_trap(struct lxtrap_type *, unsigned,
		     const struct screen_type *);
static int line_data(struct lxtrap_type *, const struct screen_type *,
		     struct lxtype_type *);
static int line_side(struct lxtrap_type *, unsigned,
		     const struct screen_type *, void *, void *);
static int line_trap(struct lxtrap_type *, unsigned,
		     const struct screen_type *, void *, void **);
static int link_trap(struct lxtrap_type *, unsigned,
		     const struct screen_type *);

static void line_____(u_case_args_____0);
static void line_cfix(u_case_args_____0);
static void line_tfix(u_case_args_____0);
static void line_wfix(u_case_args_____0);

static const int c_____t__[] = {
/* *INDENT-OFF* */
    X1f4_E4_TEXT
/* *INDENT-ON* */
};
static const struct line_type slip_line[] = {
/* *INDENT-OFF* */
#define error_count			0
    {	{	"error",
		_libx1f4i0_lxtrap_e_logique,	X1f4_E4_VOID,
		c_____t__,			1,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_____,							}
#define error_reach			(0 + error_count)
/* *INDENT-ON* */
#define slip_line_count			error_reach
}, trap_line[] = {
/* *INDENT-OFF* */
#define call_count			1
    {	{	"call",
		_libx1f4i0_lxtrap_c_logique,	0,
		NULL,				call_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_LINK_PASS
		| X1f4_E4_SIDE_LIST | X1f4_E4_TEXT_LINK
		| X1f4_E4_WALK_LINK,
						4		},
	line_cfix,							},
#define call_reach			(0 + call_count)
#define trap_count			1
    {	{	"trap",
		_libx1f4i0_lxtrap_t_logique,	X1f4_E4_MODE,
		NULL,				trap_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_LINK_PASS
		| X1f4_E4_SIDE_LIST | X1f4_E4_TEXT_LINK
		| X1f4_E4_WALK_LINK,
						4		},
	line_tfix,							},
#define trap_reach			(call_reach + trap_count)
#define wrap_count			2
    {	{	"wrap",
		_libx1f4i0_lxtrap_w_logique,	X1f4_E4_MODE,
		NULL,				wrap_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_LINK_PASS
		| X1f4_E4_POST_TYPE | X1f4_E4_SIDE_LIST
		| X1f4_E4_SLIP_LIST | X1f4_E4_TEXT_LINK
		| X1f4_E4_WALK_LINK,
						4		},
	line_wfix,							}
#define wrap_reach			(trap_reach + (wrap_count << 1))
/* *INDENT-ON* */
#define trap_line_count			wrap_reach
};

static int
init_trap(struct lxtrap_type *lxtrap_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;

    if (bits & CODELINK_LINK) {
	lxtrap_data->link_w.data = screen_data->link_w.data;
	lxtrap_data->link_w.free = screen_data->link_w.free;
	lxtrap_data->link_w.link = screen_data->link_w.link;
	lxtrap_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxtrap_data->link_w.data = NULL;
	lxtrap_data->link_w.free = _x1f4_e4_free_data;
	lxtrap_data->link_w.link = _x1f4_e4_link_data;
	lxtrap_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (1) {
	lxtrap_data->link_g.type = screen_data->link_g.type;
    }

    if (bits & IMPLICIT_LINK) {
	lxtrap_data->link_p.link = screen_data->link_p.link;
	lxtrap_data->link_p.text = screen_data->link_p.text;
    } else {
	lxtrap_data->link_p.link = NULL;
	lxtrap_data->link_p.text = NULL;
    }

    if (bits & COMPOSER_LINK) {
	lxtrap_data->link_q.link = screen_data->link_q.link;
	lxtrap_data->link_q.text = screen_data->link_q.text;
    } else {
	lxtrap_data->link_q.link = NULL;
	lxtrap_data->link_p.text = NULL;
    }

    if (bits & RESOURCE_LINK) {
	lxtrap_data->link_m.data = screen_data->link_m.data;
	lxtrap_data->link_m.free = screen_data->link_m.free;
	lxtrap_data->link_m.link = screen_data->link_m.link;
	lxtrap_data->link_m.mode = screen_data->link_m.mode;
    } else {
	lxtrap_data->link_m.data = NULL;
	lxtrap_data->link_m.free = _x1f4_e4_free_data;
	lxtrap_data->link_m.link = _x1f4_e4_link_data;
	lxtrap_data->link_m.mode = _x1f4_e4_mode_data;
    }

    if (1) {
	lxtrap_data->link_v.data = screen_data->link_v.data;
	lxtrap_data->link_v.link = screen_data->link_v.link;
    }

    if (bits & TEXTFLAT_LINK) {
	lxtrap_data->link_e.data = screen_data->link_e.data;
	lxtrap_data->link_e.line = screen_data->link_e.line;
	lxtrap_data->link_e.post = screen_data->link_e.post;
	lxtrap_data->link_e.push = screen_data->link_e.push;
    } else {
	lxtrap_data->link_e.data = NULL;
	lxtrap_data->link_e.line = NULL;
	lxtrap_data->link_e.post = NULL;
	lxtrap_data->link_e.push = NULL;
    }

    if (bits & EELOOKUP_LINK) {
	lxtrap_data->trap_e.eelookup_data = screen_data->trap_e.eelookup_data;
    } else {
	lxtrap_data->trap_e.eelookup_data = &_x1f4_type_lookup;
    }

    status = link_trap(lxtrap_data, bits, screen_data);

    return status;
}


static int
line_data(struct lxtrap_type *lxtrap_data,
	  const struct screen_type *screen_data,
	  struct lxtype_type *lxtype_data)
{
    const struct x1f4_nodetype_type *nodetype_data;
    unsigned i;

    nodetype_data = screen_data->link_t.data;

    i = screen_data->link_t.miss;
    for (; i; i--) {
	int type;

	type = nodetype_data->code;
	if (type == X1f4_E4_TEXT) {
	    lxtype_data->lead = _libx1f4i0_lxtrap_lead_text;
	    lxtype_data->slip = _libx1f4i0_lxtrap_slip_text;

	    lxtype_data->text = lxtrap_data;
	} else {
	    lxtype_data->lead = nodetype_data->lead;
	    lxtype_data->slip = nodetype_data->slip;

	    lxtype_data->text = nodetype_data->context;
	}

	lxtype_data->type = type;

	lxtype_data++;

	nodetype_data++;
    }

    return 0;
}


static int
line_side(struct lxtrap_type *lxtrap_data, unsigned bits,
	  const struct screen_type *screen_data, void *side, void *data)
{
    int status;
    struct qssc_type *qssc_data;
    struct x1f4_linetext_type *linetext_data;

    linetext_data = data;

    qssc_data = side;

    do {
	status = _libx1f4i0_lxcall_miss_line
	    (lxtrap_data, bits, screen_data->link_o.fine, qssc_data,
	     linetext_data, sizeof(trap_line) / sizeof(struct line_type));
	if (status) {
	    break;
	}

	linetext_data += sizeof(trap_line) / sizeof(struct line_type);
	qssc_data += sizeof(trap_line) / sizeof(struct line_type);

	qssc_data->variable.name = NULL;
    } while (0);

    return status;
}


static int
line_trap(struct lxtrap_type *lxtrap_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void **args)
{
    struct x1f4_linetext_type *linetext_data;

    linetext_data = data;

    if (1) {
	_libx1f4i0_lxcall_side_line
	    (lxtrap_data, bits, screen_data, linetext_data, args,
	     sizeof(slip_line) / sizeof(struct line_type), slip_line);
	linetext_data += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (1) {
	_libx1f4i0_lxcall_zero_line(linetext_data);
	linetext_data++;
    }
    if (1) {
	_libx1f4i0_lxcall_side_line
	    (lxtrap_data, bits, screen_data, linetext_data, args,
	     sizeof(trap_line) / sizeof(struct line_type), trap_line);
	linetext_data += sizeof(trap_line) / sizeof(struct line_type);
    }
    if (1) {
	_libx1f4i0_lxcall_zero_line(linetext_data);
    }

    return 0;
}


static int
link_trap(struct lxtrap_type *lxtrap_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    unsigned args_count = 0, line_count = 1, miss, slip_count = 1;
    void *data;

    {
	args_count += slip_line_count + trap_line_count;
	line_count += sizeof(slip_line) / sizeof(struct line_type);
	slip_count += sizeof(trap_line) / sizeof(struct line_type);
    }

    {
	miss = screen_data->link_t.miss;
    }

    status = lxtrap_data->link_w.link
	(lxtrap_data->link_w.data, &data,
	 args_count * sizeof(int) + miss * sizeof(struct lxtype_type)
	 + (line_count + slip_count) * sizeof(struct x1f4_linetext_type)
	 + slip_count * sizeof(struct qssc_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	void *args, *news, *rail, *text;

	news = (struct x1f4_linetext_type *) data + line_count;
	rail = (struct x1f4_linetext_type *) news + slip_count;
	text = (struct qssc_type *) rail + slip_count;
	args = (struct lxtype_type *) text + miss;

	line_data(lxtrap_data, screen_data, text);
	line_trap(lxtrap_data, bits, screen_data, data, &args);
	status = line_side(lxtrap_data, bits, screen_data, rail, news);
	if (status) {
	    lxtrap_data->link_w.free(lxtrap_data->link_w.data, data);
	} else {
	    lxtrap_data->link_f.data = data;
	    lxtrap_data->link_f.rail = rail;
	    lxtrap_data->link_t.data = text;
	    lxtrap_data->link_t.miss = miss;
	}
    }

    return status;
}


static void
line_____(u_case_args_____1)
{
}


static void
line_cfix(u_case_args_____1)
{
    int *line, type;

    line = *args;

    type = screen(screen)->link_g.type;

    linetext_data->function.args = line;

    linetext_data->function.type = type;

    *line++ = type;

    *args = line;
}


static void
line_tfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_g.type;

    *args = line;
}


static void
line_wfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = X1f4_E4_SLIP;
    *line++ = screen(screen)->link_g.type;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;

    *args = line;
}


int
x1f4_init_lxtrap(void **lxtrap, unsigned bits,
	         const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *data, *text;

    if (bits & CODELINK_LINK) {
	data = screen_data->link_w.data;
	link = screen_data->link_w.link;
    } else {
	data = (void *) 0;
	link = _x1f4_e4_link_data;
    }

    status = link(data, &text, sizeof(struct lxtrap_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_trap(text, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(data, text);
	    } else {
		_x1f4_e4_free_data(data, text);
	    }
	} else {
	    *lxtrap = text;
	}
    }

    return status;
}
