/*
 * lxtime-p.f.c
 * Copyright (C) 2008, 2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxdate-types.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TIME(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxtime_f_pending(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE window_a, window_f;
    struct dxtime_type *dxtime_data;
    unsigned second_a, second_f, second_l;

    dxtime_data = I_TIME(input[0]);

    window_a = I_MODE(input[1]);
    window_f = I_MODE(input[2]);

    if (window_a < 0) {
	if (window_f < 0) {
	    window_a = -window_a;
	    window_f = -window_f;
	    if (window_f < 1000000) {
	    } else {
		window_a += window_f / 1000000;
		window_f %= 1000000;
	    }

	    second_l = 1 << 17;

	    second_a = window_a;
	    second_f = window_f;
	} else {
	    if (window_f < 1000000) {
		window_a = -window_a;

		second_l = 1 << 17;

		if (window_f) {
		    window_a--;
		    window_f = 1000000 - window_f;
		}

		second_a = window_a;
		second_f = window_f;
	    } else {
		window_a += window_f / 1000000;
		window_f %= 1000000;
		if (window_a < 0) {
		    window_a = -window_a;

		    second_l = 1 << 17;

		    if (window_f) {
			window_a--;
			window_f = 1000000 - window_f;
		    }

		    second_a = window_a;
		    second_f = window_f;
		} else {
		    second_l = 0;

		    second_a = window_a;
		    second_f = window_f;
		}
	    }
	}
    } else {
	if (window_f < 0) {
	    window_f = -window_f;
	    window_a -= window_f / 1000000;
	    window_f %= 1000000;
	    if (window_a < 0) {
		window_a = -window_a;

		second_l = 1 << 17;

		second_a = window_a;
		second_f = window_f;
	    } else {
		if (window_a) {
		    second_l = 0;

		    if (window_f) {
			window_a--;
			window_f = 1000000 - window_f;
		    }

		    second_a = window_a;
		    second_f = window_f;
		} else {
		    if (window_f) {
			second_l = 1 << 17;

			second_a = 0;
			second_f = window_f;
		    } else {
			second_a = 0;
			second_f = 0;
			second_l = 0;
		    }
		}
	    }
	} else {
	    if (window_f < 1000000) {
	    } else {
		window_a += window_f / 1000000;
		window_f %= 1000000;
	    }

	    second_l = 0;

	    second_a = window_a;
	    second_f = window_f;
	}
    }

    dxtime_data->second_a = second_a;
    dxtime_data->second_f = second_f;
    dxtime_data->second_l = second_a % 60 | second_a / 60 % 60 << 6
	| second_a / 3600 % 24 << 12 | second_l
	| second_f * 60 / 1000000 << 18;

    return 0;
}
