/*
 * lxtime-f.s.c
 * Copyright (C) 2008, 2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxdate-inter.h>
#include <lxdate-types.h>

#define I_TIME(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_TIME(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define lock_extime(time) \
    (time)

int
_libx1f4i0_lxtime_s_forward(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxtime_type *dxtime_data, *dxtime_text;
	unsigned call;

	dxtime_data = I_TIME(input[0]);
	dxtime_text = I_TIME(input[1]);

	lock_extime(dxtime_text)->call++;

	call = dxtime_data->call;
	call--;
	if (call) {
	    dxtime_data->call = call;

	    status = 0;
	} else {
	    status = _libx1f4i0_lxdate_side_time(context, dxtime_data);
	    if (status) {
		lock_extime(dxtime_text)->call--;
		_libx1f4i0_lxdate_link_time(context, input[0]);
		if (1) {
		    break;
		}
	    } else {
	    }
	}

	l_TIME(dxtime_text, input[0]);
	l_TIME(dxtime_text, output);
    } while (0);

    return status;
}
