/*
 * lxtime-f.c.c
 * Copyright (C) 2008, 2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxdate-types.h>

#define I_TIME(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxtime_c_forward(void *context, void *output, void **input)
{
    int tear;
    struct dxtime_type *dxtime_data, *dxtime_text;

    dxtime_data = I_TIME(input[0]);
    dxtime_text = I_TIME(input[1]);

    if (dxtime_data->second_l & (1 << 17)) {
	tear = -1;
    } else {
	tear = 1;
    }

    if ((dxtime_data->second_l ^ dxtime_text->second_l) & (1 << 17)) {
    } else {
	if (dxtime_data->second_a ^ dxtime_text->second_a) {
	    if (dxtime_data->second_a < dxtime_text->second_a) {
		tear = -tear;
	    }
	} else {
	    if (dxtime_data->second_f ^ dxtime_text->second_f) {
		if (dxtime_data->second_f < dxtime_text->second_f) {
		    tear = -tear;
		}
	    } else {
		tear = 0;
	    }
	}
    }

    l_MODE(tear, output);

    return 0;
}
