/*
 * lxtime-a.x.c
 * Copyright (C) 2008, 2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxdate-inter.h>
#include <lxdate-types.h>
#include <nt.h>

#define dxtime(time) \
    ((struct dxtime_type *) (time))

int
x1f4_push_lxtime(void *subtext, void **copy, void *time,
		 const struct x1f4_nodelink_type *nodetype_data)
{
    int status;
    unsigned call;
    void *push;

    push = *copy;

    call = dxtime(push)->call;
    call--;
    if (call) {
	dxtime(push)->call = call;

	*copy = time;

	status = 0;
    } else {
	status = _libx1f4i0_lxdate_side_time(subtext, push);
	if (status) {
	    _libx1f4i0_lxdate_link_time(subtext, copy);
	} else {
	    *copy = time;
	}
    }

    return status;
}
