/*
 * lxtext-e.g.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <lxtext-inter.h>
#include <lxtext-types.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

typedef X1f4_E4_C_TEXT e4_c_text;

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxtext_i120110_0(void *context, void *output, void **input)
{
    e4_c_text text_0, text_1;
    int status;
    struct lxtext_type *lxtext_data;

    lxtext_data = context;

    text_0 = I_TEXT(input[0]);
    text_1 = I_TEXT(input[1]);

    if (text_1 == x1f4_c1_empty_string) {
	l_TEXT(text_1, output);
	l_TEXT(text_1, input[0]);

	if (text_0 != x1f4_c1_empty_string) {
	    status = lxtext_data->link_m.free
		(lxtext_data->link_m.data, text_0);
	    if (status) {
		status = _libx1f4i0_lxtext_stat_free(lxtext_data);
	    }
	} else {
	    status = 0;
	}
    } else {
	unsigned length;
	void *string;

	length = strlen(text_1) + 1;

	status = lxtext_data->link_m.link
	    (lxtext_data->link_m.data, &string, length);
	if (status) {
	    status = _libx1f4i0_lxtext_stat_link(lxtext_data);
	} else {
	    memcpy(string, text_1, length);

	    l_TEXT(string, output);
	    l_TEXT(string, input[0]);

	    if (text_0 != x1f4_c1_empty_string) {
		status = lxtext_data->link_m.free
		    (lxtext_data->link_m.data, text_0);
		if (status) {
		    status = _libx1f4i0_lxtext_stat_free(lxtext_data);
		}
	    }
	}
    }

    return status;
}
