/*
 * lxtext-e.3.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stddef.h>

#include <e4.h>
#include <lxtext-inter.h>
#include <lxtext-types.h>
#if !defined HAVE_LIBx1f4i0
# include <real.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_REAL(e, output) \
    {									      \
	X1f4_E4_C_REAL *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxtext_i091125_1(void *context, void *output, void **input)
{
    double sky;
    int status;

    status = x1f4_parse_real(&sky, I_TEXT(input[0]), NULL);
    if (status) {
	status = _libx1f4i0_lxtext_stat_line
	    (context, "atof", I_TEXT(input[0]));
    } else {
	l_REAL(sky, output);
    }

    return status;
}
