/*
 * lxtext-c.8.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <string.h>

#if !defined HAVE_LIBx1f4i0
# include <basename.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4.h>
#include <lxtext-inter.h>
#include <lxtext-types.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxtext_i101031_0(void *context, void *output, void **input)
{
    int status;
    struct lxtext_type *lxtext_data;
    unsigned size;
    void *name, *text;

    name = x1f4_basename(I_TEXT(input[0]));

    size = strlen(name) + 1;

    lxtext_data = context;

    status = lxtext_data->link_l.link(lxtext_data->link_l.data, &text, size);
    if (status) {
	status = _libx1f4i0_lxtext_stat_link(lxtext_data);
    } else {
	memcpy(text, name, size);

	l_TEXT(text, output);
    }

    return status;
}
