/*
 * lxtext-c.4.c
 * Copyright (C) 2008, 2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <lxtext-inter.h>
#include <lxtext-types.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxtext_i081113_1(void *context, void *output, void **input)
{
    char *text;
    int mode, status;
    unsigned size;

    text = I_TEXT(input[0]);
    mode = I_MODE(input[1]);

    size = strlen(text);

    do {
	if (mode < 0) {
	    mode = -mode;
	    mode--;
	    if (size < mode) {
		l_TEXT(text, output);
		status = 0;
		break;
	    } else {
		mode = size - mode;
	    }
	} else {
	    if (size < mode) {
		l_TEXT(text, output);
		status = 0;
		break;
	    }
	}

	{
	    struct lxtext_type *lxtext_data;
	    unsigned byte;
	    void *miss;

	    lxtext_data = context;

	    byte = I_MODE(input[2]) & 255;

	    status = lxtext_data->link_l.link
		(lxtext_data->link_l.data, &miss, !byte ? mode + 1 : size + 2);
	    if (status) {
		status = _libx1f4i0_lxtext_stat_link(lxtext_data);
	    } else {
		l_TEXT(miss, output);

		if (mode) {
		    memcpy(miss, text, mode);
		    miss = (char *) miss + mode;
		    text += mode;
		}
		{
		    char *deck;

		    deck = miss;
		    *deck = byte;
		}
		if (byte) {
		    memcpy((char *) miss + 1, text, size - mode + 1);
		}
	    }
	}
    } while (0);

    return status;
}
