/*
 * lxtext-c.1.c
 * Copyright (C) 2008, 2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <lxtext-inter.h>
#include <lxtext-types.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxtext_i080106_1(void *context, void *output, void **input)
{
    char *v1st, *v2nd, *v3rd;
    int status;
    struct lxtext_type *lxtext_data;
    unsigned s1st, s2nd, s3rd;
    void *text;

    lxtext_data = context;

    v1st = I_TEXT(input[0]);
    v2nd = I_TEXT(input[1]);
    v3rd = I_TEXT(input[2]);

    s1st = strlen(v1st);
    s2nd = strlen(v2nd);
    s3rd = strlen(v3rd);

    status = lxtext_data->link_l.link
	(lxtext_data->link_l.data, &text, s1st + s2nd + s3rd + 1);
    if (status) {
	status = _libx1f4i0_lxtext_stat_link(lxtext_data);
    } else {
	l_TEXT(text, output);

	memcpy(text, v1st, s1st);
	text = (char *) text + s1st;
	memcpy(text, v2nd, s2nd);
	text = (char *) text + s2nd;
	memcpy(text, v3rd, s3rd + 1);
    }

    return status;
}
