/*
 * lxtext-a.e.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <string.h>

#include <exerrors.h>
#if !defined HAVE_LIBx1f4i0
# include <lintegral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxtext-types.h>

#define lxtext(lxtext) \
    ((struct lxtext_type *) (lxtext))

int
_libx1f4i0_lxtext_stat_base(void *lxtext, long base)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtext(lxtext)->link_e.data;

	line = lxtext(lxtext)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtext(lxtext)->link_e.push;
	if (push) {
	    status = push(data, "out of range base specification (", 33);
	    if (status) {
		break;
	    } else {
		status = x1f4_vprint_dlintegral(data, push, base);
		if (status) {
		    break;
		} else {
		    status = push(data, ")", 1);
		    if (status) {
			break;
		    }
		}
	    }
	}

	post = lxtext(lxtext)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtext_stat_free(void *lxtext)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtext(lxtext)->link_e.data;

	line = lxtext(lxtext)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtext(lxtext)->link_e.push;
	if (push) {
	    status = push(data, "cannot free memory", 18);
	    if (status) {
		break;
	    }
	}

	post = lxtext(lxtext)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxtext_stat_line(void *lxtext, const char *call, const char *dieu)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtext(lxtext)->link_e.data;

	line = lxtext(lxtext)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtext(lxtext)->link_e.push;
	if (push) {
	    status = push(data, call, strlen(call));
	    if (status) {
		break;
	    } else {
		status = push(data, ": cannot parse `", 16);
		if (status) {
		    break;
		} else {
		    status = push(data, dieu, strlen(dieu));
		    if (status) {
			break;
		    } else {
			status = push(data, "'", 1);
			if (status) {
			    break;
			}
		    }
		}
	    }
	}

	post = lxtext(lxtext)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxtext_stat_link(void *lxtext)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtext(lxtext)->link_e.data;

	line = lxtext(lxtext)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtext(lxtext)->link_e.push;
	if (push) {
	    status = push(data, "cannot allocate memory", 22);
	    if (status) {
		break;
	    }
	}

	post = lxtext(lxtext)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxtext_stat_mode(void *lxtext)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxtext(lxtext)->link_e.data;

	line = lxtext(lxtext)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxtext(lxtext)->link_e.push;
	if (push) {
	    status = push(data, "cannot reallocate memory", 24);
	    if (status) {
		break;
	    }
	}

	post = lxtext(lxtext)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}
