/*
 * lxtext-a.0.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-m.0.h>
#include <e4.h>
#include <lxtext-defs.h>
#include <lxtext-inter.h>
#include <lxtext-types.h>

#define MAKE_SINGLE(a, b)		a

#define nonsense_080104_0		_libx1f4i0_lxtext_i080104_0
#define nonsense_080104_1		_libx1f4i0_lxtext_i080104_1
#define nonsense_080106_0		_libx1f4i0_lxtext_i080106_0
#define nonsense_080106_1		_libx1f4i0_lxtext_i080106_1
#define nonsense_080106_2		_libx1f4i0_lxtext_i080106_2
#define nonsense_081113_0		_libx1f4i0_lxtext_i081113_0
#define nonsense_081113_1		_libx1f4i0_lxtext_i081113_1
#define nonsense_081113_2		_libx1f4i0_lxtext_i081113_2

#define nonsense_091125_0		_libx1f4i0_lxtext_i091125_0
#define nonsense_091125_1		_libx1f4i0_lxtext_i091125_1
#define nonsense_091125_2		_libx1f4i0_lxtext_i091125_2

#define nonsense_101031_0		_libx1f4i0_lxtext_i101031_0
#define nonsense_101214_0		_libx1f4i0_lxtext_i101214_0
#define nonsense_101214_1		_libx1f4i0_lxtext_i101214_1
#define nonsense_101218_0		_libx1f4i0_lxtext_i101218_0

#define nonsense_120110_0		_libx1f4i0_lxtext_i120110_0

#define size_f() \
    sizeof(text_f) / sizeof(struct x1f4_function_type)

typedef struct tide_type {
    struct x1f4_2ndscope_type tidespan;
    struct x1f4_linetext_type linetext;
    struct x1f4_operator_type operator;
} tide_type;

static int init_text(struct lxtext_type *, unsigned,
		     const struct screen_type *);
static int line_side(struct lxtext_type *, struct tide_type *, void **);
static int line_text(struct lxtext_type *, struct x1f4_linetext_type *);
static int link_text(struct lxtext_type *, unsigned,
		     const struct screen_type *);

static const int c_____b__[] = {
/* *INDENT-OFF* */
    X1f4_E4_BILL
/* *INDENT-ON* */
}, c_____m__[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c_____t__[] = {
/* *INDENT-OFF* */
    X1f4_E4_TEXT
/* *INDENT-ON* */
}, c_____t_m[] = {
/* *INDENT-OFF* */
    X1f4_E4_TEXT,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c_____t_t[] = {
/* *INDENT-OFF* */
    X1f4_E4_TEXT,
    X1f4_E4_TEXT,
    X1f4_E4_POST_XSET,
    0
/* *INDENT-ON* */
}, c___t_m_m[] = {
/* *INDENT-OFF* */
    X1f4_E4_TEXT,
    X1f4_E4_MODE,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c___t_t_t[] = {
/* *INDENT-OFF* */
    X1f4_E4_TEXT,
    X1f4_E4_TEXT,
    X1f4_E4_TEXT
/* *INDENT-ON* */
}, c_m_m_m_b[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_BILL
/* *INDENT-ON* */
}, c_m_m_m_m[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c_t_t_t_t[] = {
/* *INDENT-OFF* */
    X1f4_E4_TEXT,
    X1f4_E4_TEXT,
    X1f4_E4_TEXT,
    X1f4_E4_TEXT
/* *INDENT-ON* */
};

static const struct x1f4_2ndscope_type side_2[] = {
/* *INDENT-OFF* */
    {	X1f4_E4_CALL_LINK,
	NULL,			NULL				}
/* *INDENT-ON* */
};
static const struct x1f4_function_type text_f[] = {
/* *INDENT-OFF* */
    {	"alpha",		nonsense_091125_2,
	X1f4_E4_MODE,		c_____t_m,	2,
	X1f4_E4_TEXT_LINK,			5			},
    {	"atof",			nonsense_091125_1,
	X1f4_E4_REAL,		c_____t__,	1,
	X1f4_E4_TEXT_LINK,			4			},
    {	"atoi",			nonsense_091125_0,
	X1f4_E4_MODE,		c_____t__,	1,
	X1f4_E4_TEXT_LINK,			4			},
    {	"aton",			nonsense_101214_0,
	X1f4_E4_BILL,		c_____t__,	1,
	X1f4_E4_TEXT_LINK,			4			},
    {	"basename",		nonsense_101031_0,
	X1f4_E4_TEXT,		c_____t__,	1,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	8			},
    {	"bfxa",			nonsense_080106_0,
	X1f4_E4_TEXT,		c_m_m_m_m,	4,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	4			},
    {	"bfxcardinal",		nonsense_101218_0,
	X1f4_E4_TEXT,		c_m_m_m_b,	4,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	11			},
    {	"bfxinteger",		nonsense_080106_0,
	X1f4_E4_TEXT,		c_m_m_m_m,	4,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	10			},
    {	"cat",			nonsense_080104_1,
	X1f4_E4_TEXT,		c_____t_t,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	3			},
    {	"cat2",			nonsense_080104_1,
	X1f4_E4_TEXT,		c_____t_t,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	4			},
    {	"cat3",			nonsense_080106_1,
	X1f4_E4_TEXT,		c___t_t_t,	3,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	4			},
    {	"cat4",			nonsense_080106_2,
	X1f4_E4_TEXT,		c_t_t_t_t,	4,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	4			},
    {	"cut",			nonsense_081113_2,
	X1f4_E4_TEXT,		c___t_m_m,	3,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	3			},
    {	"delete",		nonsense_081113_0,
	X1f4_E4_TEXT,		c_____t_m,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	6			},
    {	"insert",		nonsense_081113_1,
	X1f4_E4_TEXT,		c___t_m_m,	3,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	6			},
    {	"itoa",			nonsense_080104_0,
	X1f4_E4_TEXT,		c_____m__,	1,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	4			},
    {	"ntoa",			nonsense_101214_1,
	X1f4_E4_TEXT,		c_____b__,	1,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	4			},
    {	NULL,			NULL,
	0,			NULL,		0,
	0,					1			}
/* *INDENT-ON* */
};
static const struct x1f4_linetext_type line_0 = {
/* *INDENT-OFF* */
    {	"copy",			nonsense_120110_0,
	X1f4_E4_TEXT,		c_____t_t,	2,
	X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK,
						4			},
    NULL
/* *INDENT-ON* */
};
static const struct x1f4_operator_type side_o[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  NULL,		0400,
	X1f4_E4_TEXT,		c_____t_t,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
				1,
	NULL,			NULL					}
/* *INDENT-ON* */
};

static int
init_text(struct lxtext_type *lxtext_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;

    if (bits & CODELINK_LINK) {
	lxtext_data->link_w.data = screen_data->link_w.data;
	lxtext_data->link_w.free = screen_data->link_w.free;
	lxtext_data->link_w.link = screen_data->link_w.link;
	lxtext_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxtext_data->link_w.data = NULL;
	lxtext_data->link_w.free = _x1f4_e4_free_data;
	lxtext_data->link_w.link = _x1f4_e4_link_data;
	lxtext_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (bits & RESOURCE_LINK) {
	lxtext_data->link_m.data = screen_data->link_m.data;
	lxtext_data->link_m.free = screen_data->link_m.free;
	lxtext_data->link_m.link = screen_data->link_m.link;
	lxtext_data->link_m.mode = screen_data->link_m.mode;
    } else {
	lxtext_data->link_m.data = NULL;
	lxtext_data->link_m.free = _x1f4_e4_free_data;
	lxtext_data->link_m.link = _x1f4_e4_link_data;
	lxtext_data->link_m.mode = _x1f4_e4_mode_data;
    }

    if (1) {
	lxtext_data->link_l.data = screen_data->link_l.data;
	lxtext_data->link_l.free = screen_data->link_l.free;
	lxtext_data->link_l.link = screen_data->link_l.link;
	lxtext_data->link_l.mode = screen_data->link_l.mode;
    }

    if (bits & TEXTFLAT_LINK) {
	lxtext_data->link_e.data = screen_data->link_e.data;
	lxtext_data->link_e.line = screen_data->link_e.line;
	lxtext_data->link_e.post = screen_data->link_e.post;
	lxtext_data->link_e.push = screen_data->link_e.push;
    } else {
	lxtext_data->link_e.data = NULL;
	lxtext_data->link_e.line = NULL;
	lxtext_data->link_e.post = NULL;
	lxtext_data->link_e.push = NULL;
    }

    status = link_text(lxtext_data, bits, screen_data);

    return status;
}


static int
line_side(struct lxtext_type *lxtext_data, struct tide_type *tide_data,
	  void **slip)
{
    struct x1f4_operator_type **operator;

    operator = (void *) (tide_data + 1);

    *slip = operator;

    *operator = &tide_data->operator;

    tide_data->operator = side_o[0];
    tide_data->operator.extension2 = &tide_data->tidespan;
    tide_data->tidespan = side_2[0];
    tide_data->tidespan.line = &tide_data->linetext;
    tide_data->linetext = line_0;
    tide_data->linetext.context = lxtext_data;

    operator++;

    *operator = NULL;

    return 0;
}


static int
line_text(struct lxtext_type *lxtext_data,
	  struct x1f4_linetext_type *linetext_data)
{
    const struct x1f4_function_type *function_data;
    unsigned i;

    function_data = text_f;
    i = size_f();
    i--;
    for (; i; i--) {
	linetext_data->context = lxtext_data;
	linetext_data->function = *function_data;
	linetext_data++;
	function_data++;
    }
    {
	linetext_data->context = NULL;
	linetext_data->function = *function_data;
    }

    return 0;
}


static int
link_text(struct lxtext_type *lxtext_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    void *data;

    status = lxtext_data->link_w.link
	(lxtext_data->link_w.data, &data,
	 size_f() * sizeof(struct x1f4_linetext_type)
	 + sizeof(struct tide_type) + sizeof(struct x1f4_operator_type *) * 2);
    if (status) {
	status = LINK_ERROR;
    } else {
	void *slip;

	line_text(lxtext_data, data);

	lxtext_data->link_f.data = data;

	data = (char *) data + size_f() * sizeof(struct x1f4_linetext_type);

	line_side(lxtext_data, data, &slip);

	lxtext_data->link_f.side = slip;
    }

    return status;
}


int
x1f4_init_lxtext(void **lxtext, unsigned bits,
	         const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *data, *text;

    if (bits & CODELINK_LINK) {
	data = screen_data->link_w.data;
	link = screen_data->link_w.link;
    } else {
	data = (void *) 0;
	link = _x1f4_e4_link_data;
    }

    status = link(data, &text, sizeof(struct lxtext_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_text(text, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(data, text);
	    } else {
		_x1f4_e4_free_data(data, text);
	    }
	} else {
	    *lxtext = text;
	}
    }

    return status;
}
